/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.highlight;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.search.highlight.DefaultEncoder;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.highlight.SimpleHTMLEncoder;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.index.fieldvisitor.CustomFieldsVisitor;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.lookup.SearchLookup;

public final class HighlightUtils {
    public static final char PARAGRAPH_SEPARATOR = '\u2029';

    private HighlightUtils() {
    }

    static List<Object> loadFieldValues(FieldMapper<?> mapper, SearchContext searchContext, FetchSubPhase.HitContext hitContext) throws IOException {
        List<Object> textsToHighlight;
        if (mapper.fieldType().stored()) {
            CustomFieldsVisitor fieldVisitor = new CustomFieldsVisitor(ImmutableSet.of(mapper.names().indexName()), false);
            hitContext.reader().document(hitContext.docId(), fieldVisitor);
            textsToHighlight = fieldVisitor.fields().get(mapper.names().indexName());
            if (textsToHighlight == null) {
                textsToHighlight = ImmutableList.of();
            }
        } else {
            SearchLookup lookup2 = searchContext.lookup();
            lookup2.setNextReader(hitContext.readerContext());
            lookup2.setNextDocId(hitContext.docId());
            textsToHighlight = lookup2.source().extractRawValues(mapper.names().sourcePath());
        }
        assert (textsToHighlight != null);
        return textsToHighlight;
    }

    static class Encoders {
        static Encoder DEFAULT = new DefaultEncoder();
        static Encoder HTML = new SimpleHTMLEncoder();

        Encoders() {
        }
    }
}

