/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.highlight;

import java.util.Collections;
import java.util.Map;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.vectorhighlight.BaseFragmentsBuilder;
import org.apache.lucene.search.vectorhighlight.CustomFieldQuery;
import org.apache.lucene.search.vectorhighlight.FieldFragList;
import org.apache.lucene.search.vectorhighlight.FieldPhraseList;
import org.apache.lucene.search.vectorhighlight.FieldQuery;
import org.apache.lucene.search.vectorhighlight.FragListBuilder;
import org.apache.lucene.search.vectorhighlight.FragmentsBuilder;
import org.apache.lucene.search.vectorhighlight.ScoreOrderFragmentsBuilder;
import org.apache.lucene.search.vectorhighlight.SimpleBoundaryScanner;
import org.apache.lucene.search.vectorhighlight.SimpleFieldFragList;
import org.apache.lucene.search.vectorhighlight.SimpleFragListBuilder;
import org.apache.lucene.search.vectorhighlight.SingleFragListBuilder;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.text.StringText;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.search.fetch.FetchPhaseExecutionException;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.highlight.HighlightField;
import org.elasticsearch.search.highlight.HighlightUtils;
import org.elasticsearch.search.highlight.Highlighter;
import org.elasticsearch.search.highlight.HighlighterContext;
import org.elasticsearch.search.highlight.SearchContextHighlight;
import org.elasticsearch.search.highlight.vectorhighlight.SimpleFragmentsBuilder;
import org.elasticsearch.search.highlight.vectorhighlight.SourceScoreOrderFragmentsBuilder;
import org.elasticsearch.search.highlight.vectorhighlight.SourceSimpleFragmentsBuilder;
import org.elasticsearch.search.internal.SearchContext;

public class FastVectorHighlighter
implements Highlighter {
    private static final SimpleBoundaryScanner DEFAULT_BOUNDARY_SCANNER = new SimpleBoundaryScanner();
    private static final String CACHE_KEY = "highlight-fsv";
    private final Boolean termVectorMultiValue;

    @Inject
    public FastVectorHighlighter(Settings settings) {
        this.termVectorMultiValue = settings.getAsBoolean("search.highlight.term_vector_multi_value", (Boolean)true);
    }

    @Override
    public String[] names() {
        return new String[]{"fvh", "fast-vector-highlighter"};
    }

    @Override
    public HighlightField highlight(HighlighterContext highlighterContext) {
        Encoder encoder2;
        SearchContextHighlight.Field field2 = highlighterContext.field;
        SearchContext context = highlighterContext.context;
        FetchSubPhase.HitContext hitContext = highlighterContext.hitContext;
        FieldMapper<?> mapper = highlighterContext.mapper;
        if (!(mapper.fieldType().storeTermVectors() && mapper.fieldType().storeTermVectorOffsets() && mapper.fieldType().storeTermVectorPositions())) {
            throw new ElasticSearchIllegalArgumentException("the field [" + field2.field() + "] should be indexed with term vector with position offsets to be used with fast vector highlighter");
        }
        Encoder encoder3 = encoder2 = field2.encoder().equals("html") ? HighlightUtils.Encoders.HTML : HighlightUtils.Encoders.DEFAULT;
        if (!hitContext.cache().containsKey(CACHE_KEY)) {
            hitContext.cache().put(CACHE_KEY, new HighlighterEntry());
        }
        HighlighterEntry cache = (HighlighterEntry)hitContext.cache().get(CACHE_KEY);
        try {
            FieldQuery fieldQuery;
            if (field2.requireFieldMatch().booleanValue()) {
                if (cache.fieldMatchFieldQuery == null) {
                    cache.fieldMatchFieldQuery = new CustomFieldQuery(highlighterContext.query.originalQuery(), hitContext.topLevelReader(), true, field2.requireFieldMatch());
                }
                fieldQuery = cache.fieldMatchFieldQuery;
            } else {
                if (cache.noFieldMatchFieldQuery == null) {
                    cache.noFieldMatchFieldQuery = new CustomFieldQuery(highlighterContext.query.originalQuery(), hitContext.topLevelReader(), true, field2.requireFieldMatch());
                }
                fieldQuery = cache.noFieldMatchFieldQuery;
            }
            MapperHighlightEntry entry2 = cache.mappers.get(mapper);
            if (entry2 == null) {
                BaseFragmentsBuilder fragmentsBuilder;
                FragListBuilder fragListBuilder;
                SimpleBoundaryScanner boundaryScanner = DEFAULT_BOUNDARY_SCANNER;
                if (field2.boundaryMaxScan() != 20 || field2.boundaryChars() != SimpleBoundaryScanner.DEFAULT_BOUNDARY_CHARS) {
                    boundaryScanner = new SimpleBoundaryScanner(field2.boundaryMaxScan(), field2.boundaryChars());
                }
                if (field2.numberOfFragments() == 0) {
                    fragListBuilder = new SingleFragListBuilder();
                    fragmentsBuilder = mapper.fieldType().stored() ? new SimpleFragmentsBuilder(mapper, field2.preTags(), field2.postTags(), boundaryScanner) : new SourceSimpleFragmentsBuilder(mapper, context, field2.preTags(), field2.postTags(), boundaryScanner);
                } else {
                    FragListBuilder fragListBuilder2 = fragListBuilder = field2.fragmentOffset() == -1 ? new SimpleFragListBuilder() : new SimpleFragListBuilder(field2.fragmentOffset());
                    fragmentsBuilder = field2.scoreOrdered().booleanValue() ? (mapper.fieldType().stored() ? new ScoreOrderFragmentsBuilder(field2.preTags(), field2.postTags(), boundaryScanner) : new SourceScoreOrderFragmentsBuilder(mapper, context, field2.preTags(), field2.postTags(), boundaryScanner)) : (mapper.fieldType().stored() ? new SimpleFragmentsBuilder(mapper, field2.preTags(), field2.postTags(), boundaryScanner) : new SourceSimpleFragmentsBuilder(mapper, context, field2.preTags(), field2.postTags(), boundaryScanner));
                }
                fragmentsBuilder.setDiscreteMultiValueHighlighting(this.termVectorMultiValue);
                entry2 = new MapperHighlightEntry();
                entry2.fragListBuilder = fragListBuilder;
                entry2.fragmentsBuilder = fragmentsBuilder;
                if (cache.fvh == null) {
                    cache.fvh = new org.apache.lucene.search.vectorhighlight.FastVectorHighlighter();
                }
                CustomFieldQuery.highlightFilters.set(field2.highlightFilter());
                cache.mappers.put(mapper, entry2);
            }
            cache.fvh.setPhraseLimit(field2.phraseLimit());
            int numberOfFragments = field2.numberOfFragments() == 0 ? Integer.MAX_VALUE : field2.numberOfFragments();
            int fragmentCharSize = field2.numberOfFragments() == 0 ? Integer.MAX_VALUE : field2.fragmentCharSize();
            String[] fragments = field2.matchedFields() != null && !field2.matchedFields().isEmpty() ? cache.fvh.getBestFragments(fieldQuery, hitContext.reader(), hitContext.docId(), mapper.names().indexName(), field2.matchedFields(), fragmentCharSize, numberOfFragments, entry2.fragListBuilder, entry2.fragmentsBuilder, field2.preTags(), field2.postTags(), encoder2) : cache.fvh.getBestFragments(fieldQuery, hitContext.reader(), hitContext.docId(), mapper.names().indexName(), fragmentCharSize, numberOfFragments, entry2.fragListBuilder, entry2.fragmentsBuilder, field2.preTags(), field2.postTags(), encoder2);
            if (fragments != null && fragments.length > 0) {
                return new HighlightField(field2.field(), StringText.convertFromStringArray(fragments));
            }
            int noMatchSize = highlighterContext.field.noMatchSize();
            if (noMatchSize > 0) {
                SimpleFieldFragList fieldFragList = new SimpleFieldFragList(-1);
                ((FieldFragList)fieldFragList).add(0, noMatchSize, Collections.<FieldPhraseList.WeightedPhraseInfo>emptyList());
                fragments = entry2.fragmentsBuilder.createFragments(hitContext.reader(), hitContext.docId(), mapper.names().indexName(), fieldFragList, 1, field2.preTags(), field2.postTags(), encoder2);
                if (fragments != null && fragments.length > 0) {
                    return new HighlightField(field2.field(), StringText.convertFromStringArray(fragments));
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new FetchPhaseExecutionException(context, "Failed to highlight field [" + highlighterContext.fieldName + "]", (Throwable)e);
        }
    }

    private class HighlighterEntry {
        public org.apache.lucene.search.vectorhighlight.FastVectorHighlighter fvh;
        public FieldQuery noFieldMatchFieldQuery;
        public FieldQuery fieldMatchFieldQuery;
        public Map<FieldMapper, MapperHighlightEntry> mappers = Maps.newHashMap();

        private HighlighterEntry() {
        }
    }

    private class MapperHighlightEntry {
        public FragListBuilder fragListBuilder;
        public FragmentsBuilder fragmentsBuilder;
        public org.apache.lucene.search.highlight.Highlighter highlighter;

        private MapperHighlightEntry() {
        }
    }
}

