/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.script;

import java.util.Map;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.fetch.script.ScriptFieldsContext;
import org.elasticsearch.search.internal.SearchContext;

public class ScriptFieldsParseElement
implements SearchParseElement {
    @Override
    public void parse(XContentParser parser, SearchContext context) throws Exception {
        XContentParser.Token token2;
        String currentFieldName = null;
        while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token2 == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token2 != XContentParser.Token.START_OBJECT) continue;
            String fieldName = currentFieldName;
            String script = null;
            String scriptLang = null;
            Map<String, Object> params = null;
            boolean ignoreException = false;
            while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token2 == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token2 == XContentParser.Token.START_OBJECT) {
                    params = parser.map();
                    continue;
                }
                if (!token2.isValue()) continue;
                if ("script".equals(currentFieldName)) {
                    script = parser.text();
                    continue;
                }
                if ("lang".equals(currentFieldName)) {
                    scriptLang = parser.text();
                    continue;
                }
                if (!"ignore_failure".equals(currentFieldName)) continue;
                ignoreException = parser.booleanValue();
            }
            SearchScript searchScript = context.scriptService().search(context.lookup(), scriptLang, script, params);
            context.scriptFields().add(new ScriptFieldsContext.ScriptField(fieldName, searchScript, ignoreException));
        }
    }
}

