/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.explain;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.fetch.FetchPhaseExecutionException;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.explain.ExplainParseElement;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.rescore.RescoreSearchContext;
import org.elasticsearch.search.rescore.Rescorer;

public class ExplainFetchSubPhase
implements FetchSubPhase {
    @Override
    public Map<String, ? extends SearchParseElement> parseElements() {
        return ImmutableMap.of("explain", new ExplainParseElement());
    }

    @Override
    public boolean hitsExecutionNeeded(SearchContext context) {
        return false;
    }

    @Override
    public void hitsExecute(SearchContext context, InternalSearchHit[] hits) throws ElasticSearchException {
    }

    @Override
    public boolean hitExecutionNeeded(SearchContext context) {
        return context.explain();
    }

    @Override
    public void hitExecute(SearchContext context, FetchSubPhase.HitContext hitContext) throws ElasticSearchException {
        try {
            Explanation explanation;
            int topLevelDocId = hitContext.hit().docId();
            if (context.rescore() != null) {
                RescoreSearchContext ctx = context.rescore();
                Rescorer rescorer = ctx.rescorer();
                explanation = rescorer.explain(topLevelDocId, context, ctx);
            } else {
                explanation = context.searcher().explain(context.query(), topLevelDocId);
            }
            hitContext.hit().explanation(explanation);
        }
        catch (IOException e) {
            throw new FetchPhaseExecutionException(context, "Failed to explain doc [" + hitContext.hit().type() + "#" + hitContext.hit().id() + "]", (Throwable)e);
        }
    }
}

