/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.fetch.script.ScriptFieldsContext;
import org.elasticsearch.search.internal.SearchContext;

public class FieldsParseElement
implements SearchParseElement {
    @Override
    public void parse(XContentParser parser, SearchContext context) throws Exception {
        XContentParser.Token token2 = parser.currentToken();
        if (token2 == XContentParser.Token.START_ARRAY) {
            boolean added = false;
            while ((token2 = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                String name = parser.text();
                if (name.contains("_source.") || name.contains("doc[")) {
                    SearchScript searchScript = context.scriptService().search(context.lookup(), "mvel", name, null);
                    context.scriptFields().add(new ScriptFieldsContext.ScriptField(name, searchScript, true));
                    continue;
                }
                added = true;
                context.fieldNames().add(name);
            }
            if (!added) {
                context.emptyFieldNames();
            }
        } else if (token2 == XContentParser.Token.VALUE_STRING) {
            String name = parser.text();
            if (name.contains("_source.") || name.contains("doc[")) {
                SearchScript searchScript = context.scriptService().search(context.lookup(), "mvel", name, null);
                context.scriptFields().add(new ScriptFieldsContext.ScriptField(name, searchScript, true));
            } else {
                context.fieldNames().add(name);
            }
        }
    }
}

