/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.termsstats.longs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.text.StringText;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.termsstats.InternalTermsStatsFacet;
import org.elasticsearch.search.facet.termsstats.TermsStatsFacet;

public class InternalTermsStatsLongFacet
extends InternalTermsStatsFacet {
    private static final BytesReference STREAM_TYPE = new HashedBytesArray(Strings.toUTF8Bytes("lTS"));
    static InternalFacet.Stream STREAM = new InternalFacet.Stream(){

        @Override
        public Facet readFacet(StreamInput in) throws IOException {
            return InternalTermsStatsLongFacet.readTermsStatsFacet(in);
        }
    };
    int requiredSize;
    long missing;
    Collection<LongEntry> entries = ImmutableList.of();
    TermsStatsFacet.ComparatorType comparatorType;

    public static void registerStream() {
        InternalFacet.Streams.registerStream(STREAM, STREAM_TYPE);
    }

    @Override
    public BytesReference streamType() {
        return STREAM_TYPE;
    }

    public InternalTermsStatsLongFacet() {
    }

    public InternalTermsStatsLongFacet(String name, TermsStatsFacet.ComparatorType comparatorType, int requiredSize, Collection<LongEntry> entries, long missing) {
        super(name);
        this.comparatorType = comparatorType;
        this.requiredSize = requiredSize;
        this.entries = entries;
        this.missing = missing;
    }

    public List<LongEntry> getEntries() {
        if (!(this.entries instanceof List)) {
            this.entries = ImmutableList.copyOf(this.entries);
        }
        return (List)this.entries;
    }

    List<LongEntry> mutableList() {
        if (!(this.entries instanceof List)) {
            this.entries = new ArrayList<LongEntry>(this.entries);
        }
        return (List)this.entries;
    }

    @Override
    public Iterator<TermsStatsFacet.Entry> iterator() {
        return this.entries.iterator();
    }

    @Override
    public long getMissingCount() {
        return this.missing;
    }

    @Override
    public Facet reduce(InternalFacet.ReduceContext context) {
        LongEntry value2;
        List<Facet> facets = context.facets();
        if (facets.size() == 1) {
            InternalTermsStatsLongFacet tsFacet = (InternalTermsStatsLongFacet)facets.get(0);
            if (this.requiredSize == 0 && !tsFacet.entries.isEmpty()) {
                List<LongEntry> entries = tsFacet.mutableList();
                CollectionUtil.timSort(entries, this.comparatorType.comparator());
            }
            tsFacet.trimExcessEntries();
            return facets.get(0);
        }
        int missing = 0;
        Recycler.V map2 = context.cacheRecycler().longObjectMap(-1);
        for (Facet facet : facets) {
            InternalTermsStatsLongFacet tsFacet = (InternalTermsStatsLongFacet)facet;
            missing = (int)((long)missing + tsFacet.missing);
            for (TermsStatsFacet.Entry entry2 : tsFacet) {
                LongEntry longEntry = (LongEntry)entry2;
                LongEntry current = (LongEntry)map2.v().get(longEntry.term);
                if (current != null) {
                    current.count += longEntry.count;
                    current.totalCount += longEntry.totalCount;
                    current.total += longEntry.total;
                    if (longEntry.min < current.min) {
                        current.min = longEntry.min;
                    }
                    if (!(longEntry.max > current.max)) continue;
                    current.max = longEntry.max;
                    continue;
                }
                map2.v().put(longEntry.term, longEntry);
            }
        }
        if (this.requiredSize == 0) {
            LongEntry[] entries1 = map2.v().values().toArray(LongEntry.class);
            Arrays.sort(entries1, this.comparatorType.comparator());
            map2.release();
            return new InternalTermsStatsLongFacet(this.getName(), this.comparatorType, this.requiredSize, Arrays.asList(entries1), missing);
        }
        VType[] values2 = map2.v().values;
        Arrays.sort(values2, this.comparatorType.comparator());
        ArrayList<LongEntry> ordered = new ArrayList<LongEntry>(map2.v().size());
        for (int i = 0; i < this.requiredSize && (value2 = (LongEntry)values2[i]) != null; ++i) {
            ordered.add(value2);
        }
        map2.release();
        return new InternalTermsStatsLongFacet(this.getName(), this.comparatorType, this.requiredSize, ordered, missing);
    }

    private void trimExcessEntries() {
        if (this.requiredSize == 0 || this.requiredSize >= this.entries.size()) {
            return;
        }
        if (this.entries instanceof List) {
            this.entries = ((List)this.entries).subList(0, this.requiredSize);
            return;
        }
        int i = 0;
        Iterator<LongEntry> iter2 = this.entries.iterator();
        while (iter2.hasNext()) {
            iter2.next();
            if (i++ < this.requiredSize) continue;
            iter2.remove();
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        builder.field(Fields._TYPE, "terms_stats");
        builder.field(Fields.MISSING, this.missing);
        builder.startArray(Fields.TERMS);
        for (LongEntry entry2 : this.entries) {
            builder.startObject();
            builder.field(Fields.TERM, entry2.term);
            builder.field(Fields.COUNT, entry2.getCount());
            builder.field(Fields.TOTAL_COUNT, entry2.getTotalCount());
            builder.field(Fields.MIN, entry2.getMin());
            builder.field(Fields.MAX, entry2.getMax());
            builder.field(Fields.TOTAL, entry2.getTotal());
            builder.field(Fields.MEAN, entry2.getMean());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static InternalTermsStatsLongFacet readTermsStatsFacet(StreamInput in) throws IOException {
        InternalTermsStatsLongFacet facet = new InternalTermsStatsLongFacet();
        facet.readFrom(in);
        return facet;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.comparatorType = TermsStatsFacet.ComparatorType.fromId(in.readByte());
        this.requiredSize = in.readVInt();
        this.missing = in.readVLong();
        int size2 = in.readVInt();
        this.entries = new ArrayList<LongEntry>(size2);
        for (int i = 0; i < size2; ++i) {
            this.entries.add(new LongEntry(in.readLong(), in.readVLong(), in.readVLong(), in.readDouble(), in.readDouble(), in.readDouble()));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeByte(this.comparatorType.id());
        out.writeVInt(this.requiredSize);
        out.writeVLong(this.missing);
        out.writeVInt(this.entries.size());
        for (LongEntry entry2 : this.entries) {
            out.writeLong(entry2.term);
            out.writeVLong(entry2.getCount());
            out.writeVLong(entry2.getTotalCount());
            out.writeDouble(entry2.getTotal());
            out.writeDouble(entry2.getMin());
            out.writeDouble(entry2.getMax());
        }
    }

    static final class Fields {
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString MISSING = new XContentBuilderString("missing");
        static final XContentBuilderString TERMS = new XContentBuilderString("terms");
        static final XContentBuilderString TERM = new XContentBuilderString("term");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");
        static final XContentBuilderString TOTAL_COUNT = new XContentBuilderString("total_count");
        static final XContentBuilderString MIN = new XContentBuilderString("min");
        static final XContentBuilderString MAX = new XContentBuilderString("max");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString MEAN = new XContentBuilderString("mean");

        Fields() {
        }
    }

    public static class LongEntry
    implements TermsStatsFacet.Entry {
        long term;
        long count;
        long totalCount;
        double total;
        double min;
        double max;

        public LongEntry(long term, long count2, long totalCount, double total, double min2, double max2) {
            this.term = term;
            this.count = count2;
            this.totalCount = totalCount;
            this.total = total;
            this.min = min2;
            this.max = max2;
        }

        @Override
        public Text getTerm() {
            return new StringText(Long.toString(this.term));
        }

        @Override
        public Number getTermAsNumber() {
            return this.term;
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public long getTotalCount() {
            return this.totalCount;
        }

        @Override
        public double getMin() {
            return this.min;
        }

        @Override
        public double getMax() {
            return this.max;
        }

        @Override
        public double getTotal() {
            return this.total;
        }

        @Override
        public double getMean() {
            if (this.totalCount == 0L) {
                return 0.0;
            }
            return this.total / (double)this.totalCount;
        }

        @Override
        public int compareTo(TermsStatsFacet.Entry o) {
            LongEntry other = (LongEntry)o;
            return this.term < other.term ? -1 : (this.term == other.term ? 0 : 1);
        }
    }
}

