/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.termsstats.doubles;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.hppc.DoubleObjectOpenHashMap;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.DoubleFacetAggregatorBase;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.termsstats.TermsStatsFacet;
import org.elasticsearch.search.facet.termsstats.doubles.InternalTermsStatsDoubleFacet;
import org.elasticsearch.search.internal.SearchContext;

public class TermsStatsDoubleFacetExecutor
extends FacetExecutor {
    private final TermsStatsFacet.ComparatorType comparatorType;
    final IndexNumericFieldData keyIndexFieldData;
    final IndexNumericFieldData valueIndexFieldData;
    final SearchScript script;
    private final int size;
    private final int shardSize;
    final Recycler.V<DoubleObjectOpenHashMap<InternalTermsStatsDoubleFacet.DoubleEntry>> entries;
    long missing;

    public TermsStatsDoubleFacetExecutor(IndexNumericFieldData keyIndexFieldData, IndexNumericFieldData valueIndexFieldData, SearchScript script, int size2, int shardSize, TermsStatsFacet.ComparatorType comparatorType, SearchContext context) {
        this.size = size2;
        this.shardSize = shardSize;
        this.comparatorType = comparatorType;
        this.keyIndexFieldData = keyIndexFieldData;
        this.valueIndexFieldData = valueIndexFieldData;
        this.script = script;
        this.entries = context.cacheRecycler().doubleObjectMap(-1);
    }

    @Override
    public Collector collector() {
        return new Collector();
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        InternalTermsStatsDoubleFacet.DoubleEntry value2;
        if (this.entries.v().isEmpty()) {
            this.entries.release();
            return new InternalTermsStatsDoubleFacet(facetName, this.comparatorType, this.size, ImmutableList.<InternalTermsStatsDoubleFacet.DoubleEntry>of(), this.missing);
        }
        if (this.size == 0) {
            ArrayList<InternalTermsStatsDoubleFacet.DoubleEntry> doubleEntries = new ArrayList<InternalTermsStatsDoubleFacet.DoubleEntry>(this.entries.v().size());
            boolean[] states = this.entries.v().allocated;
            VType[] values2 = this.entries.v().values;
            for (int i = 0; i < states.length; ++i) {
                if (!states[i]) continue;
                doubleEntries.add((InternalTermsStatsDoubleFacet.DoubleEntry)values2[i]);
            }
            this.entries.release();
            return new InternalTermsStatsDoubleFacet(facetName, this.comparatorType, 0, doubleEntries, this.missing);
        }
        VType[] values3 = this.entries.v().values;
        Arrays.sort(values3, this.comparatorType.comparator());
        int limit = this.shardSize;
        ArrayList<InternalTermsStatsDoubleFacet.DoubleEntry> ordered = Lists.newArrayList();
        for (int i = 0; i < limit && (value2 = (InternalTermsStatsDoubleFacet.DoubleEntry)values3[i]) != null; ++i) {
            ordered.add(value2);
        }
        this.entries.release();
        return new InternalTermsStatsDoubleFacet(facetName, this.comparatorType, this.size, ordered, this.missing);
    }

    public static class ScriptAggregator
    extends Aggregator {
        private final SearchScript script;

        public ScriptAggregator(DoubleObjectOpenHashMap<InternalTermsStatsDoubleFacet.DoubleEntry> entries, SearchScript script) {
            super(entries);
            this.script = script;
        }

        @Override
        public void onValue(int docId, double value2) {
            InternalTermsStatsDoubleFacet.DoubleEntry doubleEntry = (InternalTermsStatsDoubleFacet.DoubleEntry)this.entries.get(value2);
            if (doubleEntry == null) {
                doubleEntry = new InternalTermsStatsDoubleFacet.DoubleEntry(value2, 1L, 0L, 0.0, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
                this.entries.put(value2, doubleEntry);
            } else {
                ++doubleEntry.count;
            }
            this.script.setNextDocId(docId);
            double valueValue = this.script.runAsDouble();
            if (valueValue < doubleEntry.min) {
                doubleEntry.min = valueValue;
            }
            if (valueValue > doubleEntry.max) {
                doubleEntry.max = valueValue;
            }
            ++doubleEntry.totalCount;
            doubleEntry.total += valueValue;
        }
    }

    public static class Aggregator
    extends DoubleFacetAggregatorBase {
        final DoubleObjectOpenHashMap<InternalTermsStatsDoubleFacet.DoubleEntry> entries;
        int missing;
        DoubleValues valueFieldData;
        final ValueAggregator valueAggregator = new ValueAggregator();

        public Aggregator(DoubleObjectOpenHashMap<InternalTermsStatsDoubleFacet.DoubleEntry> entries) {
            this.entries = entries;
        }

        @Override
        public void onValue(int docId, double value2) {
            InternalTermsStatsDoubleFacet.DoubleEntry doubleEntry = this.entries.get(value2);
            if (doubleEntry == null) {
                doubleEntry = new InternalTermsStatsDoubleFacet.DoubleEntry(value2, 0L, 0L, 0.0, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
                this.entries.put(value2, doubleEntry);
            }
            ++doubleEntry.count;
            this.valueAggregator.doubleEntry = doubleEntry;
            this.valueAggregator.onDoc(docId, this.valueFieldData);
        }

        public static class ValueAggregator
        extends DoubleFacetAggregatorBase {
            InternalTermsStatsDoubleFacet.DoubleEntry doubleEntry;

            @Override
            public void onValue(int docId, double value2) {
                if (value2 < this.doubleEntry.min) {
                    this.doubleEntry.min = value2;
                }
                if (value2 > this.doubleEntry.max) {
                    this.doubleEntry.max = value2;
                }
                this.doubleEntry.total += value2;
                ++this.doubleEntry.totalCount;
            }
        }
    }

    class Collector
    extends FacetExecutor.Collector {
        private final Aggregator aggregator;
        private DoubleValues keyValues;

        public Collector() {
            this.aggregator = TermsStatsDoubleFacetExecutor.this.script == null ? new Aggregator(TermsStatsDoubleFacetExecutor.this.entries.v()) : new ScriptAggregator(TermsStatsDoubleFacetExecutor.this.entries.v(), TermsStatsDoubleFacetExecutor.this.script);
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            if (TermsStatsDoubleFacetExecutor.this.script != null) {
                TermsStatsDoubleFacetExecutor.this.script.setScorer(scorer);
            }
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.keyValues = TermsStatsDoubleFacetExecutor.this.keyIndexFieldData.load(context).getDoubleValues();
            if (TermsStatsDoubleFacetExecutor.this.script != null) {
                TermsStatsDoubleFacetExecutor.this.script.setNextReader(context);
            } else {
                this.aggregator.valueFieldData = TermsStatsDoubleFacetExecutor.this.valueIndexFieldData.load(context).getDoubleValues();
            }
        }

        @Override
        public void collect(int doc) throws IOException {
            this.aggregator.onDoc(doc, this.keyValues);
        }

        @Override
        public void postCollection() {
            TermsStatsDoubleFacetExecutor.this.missing = this.aggregator.missing;
        }
    }
}

