/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.termsstats;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.FacetParser;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.termsstats.InternalTermsStatsFacet;
import org.elasticsearch.search.facet.termsstats.TermsStatsFacet;
import org.elasticsearch.search.facet.termsstats.doubles.TermsStatsDoubleFacetExecutor;
import org.elasticsearch.search.facet.termsstats.longs.TermsStatsLongFacetExecutor;
import org.elasticsearch.search.facet.termsstats.strings.TermsStatsStringFacetExecutor;
import org.elasticsearch.search.internal.SearchContext;

public class TermsStatsFacetParser
extends AbstractComponent
implements FacetParser {
    @Inject
    public TermsStatsFacetParser(Settings settings) {
        super(settings);
        InternalTermsStatsFacet.registerStreams();
    }

    @Override
    public String[] types() {
        return new String[]{"terms_stats", "termsStats"};
    }

    @Override
    public FacetExecutor.Mode defaultMainMode() {
        return FacetExecutor.Mode.COLLECTOR;
    }

    @Override
    public FacetExecutor.Mode defaultGlobalMode() {
        return FacetExecutor.Mode.COLLECTOR;
    }

    @Override
    public FacetExecutor parse(String facetName, XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token2;
        String keyField = null;
        String valueField = null;
        int size2 = 10;
        int shardSize = -1;
        TermsStatsFacet.ComparatorType comparatorType = TermsStatsFacet.ComparatorType.COUNT;
        String scriptLang = null;
        String script = null;
        Map<String, Object> params = null;
        String currentFieldName = null;
        while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token2 == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token2 == XContentParser.Token.START_OBJECT) {
                if (!"params".equals(currentFieldName)) continue;
                params = parser.map();
                continue;
            }
            if (!token2.isValue()) continue;
            if ("key_field".equals(currentFieldName) || "keyField".equals(currentFieldName)) {
                keyField = parser.text();
                continue;
            }
            if ("value_field".equals(currentFieldName) || "valueField".equals(currentFieldName)) {
                valueField = parser.text();
                continue;
            }
            if ("script_field".equals(currentFieldName) || "scriptField".equals(currentFieldName)) {
                script = parser.text();
                continue;
            }
            if ("value_script".equals(currentFieldName) || "valueScript".equals(currentFieldName)) {
                script = parser.text();
                continue;
            }
            if ("size".equals(currentFieldName)) {
                size2 = parser.intValue();
                continue;
            }
            if ("shard_size".equals(currentFieldName) || "shardSize".equals(currentFieldName)) {
                shardSize = parser.intValue();
                continue;
            }
            if ("all_terms".equals(currentFieldName) || "allTerms".equals(currentFieldName)) {
                if (!parser.booleanValue()) continue;
                size2 = 0;
                continue;
            }
            if ("order".equals(currentFieldName) || "comparator".equals(currentFieldName)) {
                comparatorType = TermsStatsFacet.ComparatorType.fromString(parser.text());
                continue;
            }
            if (!"lang".equals(currentFieldName)) continue;
            scriptLang = parser.text();
        }
        if (keyField == null) {
            throw new FacetPhaseExecutionException(facetName, "[key_field] is required to be set for terms stats facet");
        }
        if (valueField == null && script == null) {
            throw new FacetPhaseExecutionException(facetName, "either [value_field] or [script] are required to be set for terms stats facet");
        }
        FieldMapper keyMapper = context.smartNameFieldMapper(keyField);
        if (keyMapper == null) {
            throw new FacetPhaseExecutionException(facetName, "failed to find mapping for " + keyField);
        }
        Object keyIndexFieldData = context.fieldData().getForField(keyMapper);
        if (shardSize < size2) {
            shardSize = size2;
        }
        IndexNumericFieldData valueIndexFieldData = null;
        SearchScript valueScript = null;
        if (valueField != null) {
            FieldMapper fieldMapper = context.smartNameFieldMapper(valueField);
            if (fieldMapper == null) {
                throw new FacetPhaseExecutionException(facetName, "failed to find mapping for " + valueField);
            }
            if (!(fieldMapper instanceof NumberFieldMapper)) {
                throw new FacetPhaseExecutionException(facetName, "value_field [" + valueField + "] isn't a number field, but a " + fieldMapper.fieldDataType().getType());
            }
            valueIndexFieldData = (IndexNumericFieldData)context.fieldData().getForField(fieldMapper);
        } else {
            valueScript = context.scriptService().search(context.lookup(), scriptLang, script, params);
        }
        if (keyIndexFieldData instanceof IndexNumericFieldData) {
            IndexNumericFieldData keyIndexNumericFieldData = (IndexNumericFieldData)keyIndexFieldData;
            if (keyIndexNumericFieldData.getNumericType().isFloatingPoint()) {
                return new TermsStatsDoubleFacetExecutor(keyIndexNumericFieldData, valueIndexFieldData, valueScript, size2, shardSize, comparatorType, context);
            }
            return new TermsStatsLongFacetExecutor(keyIndexNumericFieldData, valueIndexFieldData, valueScript, size2, shardSize, comparatorType, context);
        }
        return new TermsStatsStringFacetExecutor((IndexFieldData)keyIndexFieldData, valueIndexFieldData, valueScript, size2, shardSize, comparatorType, context);
    }
}

