/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms.unmapped;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.terms.TermsFacet;
import org.elasticsearch.search.facet.terms.strings.InternalStringTermsFacet;

public class UnmappedFieldExecutor
extends FacetExecutor {
    final int size;
    final TermsFacet.ComparatorType comparatorType;
    long missing;

    public UnmappedFieldExecutor(int size2, TermsFacet.ComparatorType comparatorType) {
        this.size = size2;
        this.comparatorType = comparatorType;
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        ImmutableList<InternalStringTermsFacet.TermEntry> entries = ImmutableList.of();
        return new InternalStringTermsFacet(facetName, this.comparatorType, this.size, entries, this.missing, 0L);
    }

    @Override
    public Collector collector() {
        return new Collector();
    }

    final class Collector
    extends FacetExecutor.Collector {
        private long missing;

        Collector() {
        }

        @Override
        public void postCollection() {
            UnmappedFieldExecutor.this.missing = this.missing;
        }

        @Override
        public void collect(int doc) throws IOException {
            ++this.missing;
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
        }
    }
}

