/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms.strings;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.PriorityQueue;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.cache.recycler.CacheRecycler;
import org.elasticsearch.common.collect.BoundedTreeSet;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.terms.TermsFacet;
import org.elasticsearch.search.facet.terms.strings.InternalStringTermsFacet;
import org.elasticsearch.search.facet.terms.support.EntryPriorityQueue;
import org.elasticsearch.search.internal.SearchContext;

public class TermsStringOrdinalsFacetExecutor
extends FacetExecutor {
    private final IndexFieldData.WithOrdinals indexFieldData;
    final CacheRecycler cacheRecycler;
    private final TermsFacet.ComparatorType comparatorType;
    private final int size;
    private final int shardSize;
    private final int minCount;
    private final ImmutableSet<BytesRef> excluded;
    private final Matcher matcher;
    final int ordinalsCacheAbove;
    final List<ReaderAggregator> aggregators;
    long missing;
    long total;

    public TermsStringOrdinalsFacetExecutor(IndexFieldData.WithOrdinals indexFieldData, int size2, int shardSize, TermsFacet.ComparatorType comparatorType, boolean allTerms, SearchContext context, ImmutableSet<BytesRef> excluded, Pattern pattern, int ordinalsCacheAbove) {
        this.indexFieldData = indexFieldData;
        this.size = size2;
        this.shardSize = shardSize;
        this.comparatorType = comparatorType;
        this.ordinalsCacheAbove = ordinalsCacheAbove;
        this.excluded = excluded == null || excluded.isEmpty() ? null : excluded;
        this.matcher = pattern != null ? pattern.matcher("") : null;
        this.minCount = allTerms ? -1 : 0;
        this.cacheRecycler = context.cacheRecycler();
        this.aggregators = new ArrayList<ReaderAggregator>(context.searcher().getIndexReader().leaves().size());
    }

    @Override
    public Collector collector() {
        return new Collector();
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        ReaderAggregator agg;
        Object ordered;
        CharsRef spare = new CharsRef();
        AggregatorPriorityQueue queue = new AggregatorPriorityQueue(this.aggregators.size());
        for (ReaderAggregator aggregator : this.aggregators) {
            if (!aggregator.nextPosition()) continue;
            queue.add(aggregator);
        }
        if (this.shardSize < 5000) {
            ordered = new EntryPriorityQueue(this.shardSize, this.comparatorType.comparator());
            while (queue.size() > 0) {
                agg = (ReaderAggregator)queue.top();
                BytesRef value2 = agg.copyCurrent();
                int count2 = 0;
                do {
                    count2 += agg.counts.get(agg.position);
                    if (agg.nextPosition()) {
                        agg = (ReaderAggregator)queue.updateTop();
                        continue;
                    }
                    queue.pop();
                    agg = (ReaderAggregator)queue.top();
                } while (agg != null && value2.equals(agg.current));
                if (count2 <= this.minCount || this.excluded != null && this.excluded.contains(value2)) continue;
                if (this.matcher != null) {
                    UnicodeUtil.UTF8toUTF16(value2, spare);
                    assert (spare.toString().equals(value2.utf8ToString()));
                    if (!this.matcher.reset(spare).matches()) continue;
                }
                InternalStringTermsFacet.TermEntry entry2 = new InternalStringTermsFacet.TermEntry(value2, count2);
                ((PriorityQueue)ordered).insertWithOverflow(entry2);
            }
            InternalStringTermsFacet.TermEntry[] list2 = new InternalStringTermsFacet.TermEntry[((PriorityQueue)ordered).size()];
            for (int i = ((PriorityQueue)ordered).size() - 1; i >= 0; --i) {
                list2[i] = (InternalStringTermsFacet.TermEntry)((PriorityQueue)ordered).pop();
            }
            return new InternalStringTermsFacet(facetName, this.comparatorType, this.size, Arrays.asList(list2), this.missing, this.total);
        }
        ordered = new BoundedTreeSet<TermsFacet.Entry>(this.comparatorType.comparator(), this.shardSize);
        while (queue.size() > 0) {
            agg = (ReaderAggregator)queue.top();
            BytesRef value3 = agg.copyCurrent();
            int count3 = 0;
            do {
                count3 += agg.counts.get(agg.position);
                if (agg.nextPosition()) {
                    agg = (ReaderAggregator)queue.updateTop();
                    continue;
                }
                queue.pop();
                agg = (ReaderAggregator)queue.top();
            } while (agg != null && value3.equals(agg.current));
            if (count3 <= this.minCount || this.excluded != null && this.excluded.contains(value3)) continue;
            if (this.matcher != null) {
                UnicodeUtil.UTF8toUTF16(value3, spare);
                assert (spare.toString().equals(value3.utf8ToString()));
                if (!this.matcher.reset(spare).matches()) continue;
            }
            InternalStringTermsFacet.TermEntry entry3 = new InternalStringTermsFacet.TermEntry(value3, count3);
            ((BoundedTreeSet)ordered).add(entry3);
        }
        return new InternalStringTermsFacet(facetName, this.comparatorType, this.size, (Collection<InternalStringTermsFacet.TermEntry>)ordered, this.missing, this.total);
    }

    public static class AggregatorPriorityQueue
    extends PriorityQueue<ReaderAggregator> {
        public AggregatorPriorityQueue(int size2) {
            super(size2);
        }

        @Override
        protected boolean lessThan(ReaderAggregator a, ReaderAggregator b) {
            return a.current.compareTo(b.current) < 0;
        }
    }

    public static final class ReaderAggregator {
        private final long maxOrd;
        final BytesValues.WithOrdinals values;
        final IntArray counts;
        long position = 0L;
        BytesRef current;
        int total;

        public ReaderAggregator(BytesValues.WithOrdinals values2, int ordinalsCacheLimit, CacheRecycler cacheRecycler) {
            this.values = values2;
            this.maxOrd = values2.ordinals().getMaxOrd();
            this.counts = BigArrays.newIntArray(this.maxOrd);
        }

        final void onOrdinal(int docId, long ordinal) {
            this.counts.increment(ordinal, 1);
            ++this.total;
        }

        final void incrementMissing(int numMissing) {
            this.counts.increment(0L, numMissing);
            this.total += numMissing;
        }

        public boolean nextPosition() {
            if (++this.position >= this.maxOrd) {
                return false;
            }
            this.current = this.values.getValueByOrd(this.position);
            return true;
        }

        public BytesRef copyCurrent() {
            return this.values.copyShared();
        }
    }

    class Collector
    extends FacetExecutor.Collector {
        private long missing;
        private long total;
        private BytesValues.WithOrdinals values;
        private ReaderAggregator current;
        private Ordinals.Docs ordinals;

        Collector() {
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            if (this.current != null) {
                this.missing += (long)this.current.counts.get(0L);
                this.total += (long)(this.current.total - this.current.counts.get(0L));
                if (this.current.values.ordinals().getNumOrds() > 0L) {
                    TermsStringOrdinalsFacetExecutor.this.aggregators.add(this.current);
                }
            }
            this.values = TermsStringOrdinalsFacetExecutor.this.indexFieldData.load(context).getBytesValues(false);
            this.current = new ReaderAggregator(this.values, TermsStringOrdinalsFacetExecutor.this.ordinalsCacheAbove, TermsStringOrdinalsFacetExecutor.this.cacheRecycler);
            this.ordinals = this.values.ordinals();
        }

        @Override
        public void collect(int doc) throws IOException {
            int length = this.ordinals.setDocument(doc);
            int missing = 1;
            for (int i = 0; i < length; ++i) {
                this.current.onOrdinal(doc, this.ordinals.nextOrd());
                missing = 0;
            }
            this.current.incrementMissing(missing);
        }

        @Override
        public void postCollection() {
            if (this.current != null) {
                this.missing += (long)this.current.counts.get(0L);
                this.total += (long)(this.current.total - this.current.counts.get(0L));
                if (this.current.values.ordinals().getNumOrds() > 0L) {
                    TermsStringOrdinalsFacetExecutor.this.aggregators.add(this.current);
                }
                this.current = null;
            }
            TermsStringOrdinalsFacetExecutor.this.missing = this.missing;
            TermsStringOrdinalsFacetExecutor.this.total = this.total;
        }
    }
}

