/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms.strings;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.terms.strings.HashedAggregator;

public final class HashedScriptAggregator
extends HashedAggregator {
    private final ImmutableSet<BytesRef> excluded;
    private final Matcher matcher;
    private final SearchScript script;
    private final CharsRef spare = new CharsRef();
    private final BytesRef scriptSpare = new BytesRef();
    private final boolean convert;

    public HashedScriptAggregator(ImmutableSet<BytesRef> excluded, Pattern pattern, SearchScript script) {
        this.excluded = excluded;
        this.matcher = pattern != null ? pattern.matcher("") : null;
        this.script = script;
        this.convert = script != null || this.matcher != null;
    }

    @Override
    public void addValue(BytesRef value2, int hashCode, BytesValues values2) {
        if (this.accept(value2)) {
            super.addValue(value2, hashCode, values2);
        }
    }

    private boolean accept(BytesRef value2) {
        if (this.excluded != null && this.excluded.contains(value2)) {
            return false;
        }
        if (this.convert) {
            UnicodeUtil.UTF8toUTF16(value2, this.spare);
            if (this.matcher != null) {
                assert (this.convert) : "regexp: [convert == false] but should be true";
                assert (value2.utf8ToString().equals(this.spare.toString())) : "not converted";
                return this.matcher.reset(this.spare).matches();
            }
        }
        return true;
    }

    @Override
    protected void onValue(int docId, BytesRef value2, int hashCode, BytesValues values2) {
        if (this.accept(value2)) {
            if (this.script != null) {
                assert (this.convert) : "script: [convert == false] but should be true";
                assert (value2.utf8ToString().equals(this.spare.toString())) : "not converted";
                this.script.setNextDocId(docId);
                this.script.setNextVar("term", this.spare.toString());
                Object scriptValue = this.script.run();
                if (scriptValue == null) {
                    return;
                }
                if (scriptValue instanceof Boolean) {
                    if (!((Boolean)scriptValue).booleanValue()) {
                        return;
                    }
                } else {
                    this.scriptSpare.copyChars(scriptValue.toString());
                    hashCode = this.scriptSpare.hashCode();
                    super.onValue(docId, this.scriptSpare, hashCode, values2);
                    return;
                }
            }
            assert (this.convert || this.matcher == null && this.script == null);
            super.onValue(docId, value2, hashCode, values2);
        }
    }
}

