/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms.doubles;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.collect.BoundedTreeSet;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.hppc.DoubleIntOpenHashMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.text.StringText;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.terms.InternalTermsFacet;
import org.elasticsearch.search.facet.terms.TermsFacet;

public class InternalDoubleTermsFacet
extends InternalTermsFacet {
    private static final BytesReference STREAM_TYPE = new HashedBytesArray(Strings.toUTF8Bytes("dTerms"));
    static InternalFacet.Stream STREAM = new InternalFacet.Stream(){

        @Override
        public Facet readFacet(StreamInput in) throws IOException {
            return InternalDoubleTermsFacet.readTermsFacet(in);
        }
    };
    int requiredSize;
    long missing;
    long total;
    Collection<DoubleEntry> entries = ImmutableList.of();
    TermsFacet.ComparatorType comparatorType;

    public static void registerStream() {
        InternalFacet.Streams.registerStream(STREAM, STREAM_TYPE);
    }

    @Override
    public BytesReference streamType() {
        return STREAM_TYPE;
    }

    InternalDoubleTermsFacet() {
    }

    public InternalDoubleTermsFacet(String name, TermsFacet.ComparatorType comparatorType, int requiredSize, Collection<DoubleEntry> entries, long missing, long total) {
        super(name);
        this.comparatorType = comparatorType;
        this.requiredSize = requiredSize;
        this.entries = entries;
        this.missing = missing;
        this.total = total;
    }

    public List<DoubleEntry> getEntries() {
        if (!(this.entries instanceof List)) {
            this.entries = ImmutableList.copyOf(this.entries);
        }
        return (List)this.entries;
    }

    @Override
    public Iterator<TermsFacet.Entry> iterator() {
        return this.entries.iterator();
    }

    @Override
    public long getMissingCount() {
        return this.missing;
    }

    @Override
    public long getTotalCount() {
        return this.total;
    }

    @Override
    public long getOtherCount() {
        long other = this.total;
        for (DoubleEntry entry2 : this.entries) {
            other -= (long)entry2.getCount();
        }
        return other;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Facet reduce(InternalFacet.ReduceContext context) {
        void var13_14;
        List<Facet> facets = context.facets();
        if (facets.size() == 1) {
            Facet facet = facets.get(0);
            if (facet instanceof InternalDoubleTermsFacet) {
                ((InternalDoubleTermsFacet)facet).trimExcessEntries();
            }
            return facet;
        }
        InternalDoubleTermsFacet first = null;
        Recycler.V<DoubleIntOpenHashMap> aggregated = context.cacheRecycler().doubleIntMap(-1);
        long missing = 0L;
        long total = 0L;
        for (Facet facet : facets) {
            TermsFacet termsFacet = (TermsFacet)facet;
            if (first == null && termsFacet instanceof InternalDoubleTermsFacet) {
                first = (InternalDoubleTermsFacet)termsFacet;
            }
            missing += termsFacet.getMissingCount();
            total += termsFacet.getTotalCount();
            for (TermsFacet.Entry entry2 : termsFacet.getEntries()) {
                aggregated.v().addTo(((DoubleEntry)entry2).term, entry2.getCount());
            }
        }
        BoundedTreeSet<TermsFacet.Entry> ordered = new BoundedTreeSet<TermsFacet.Entry>(first.comparatorType.comparator(), first.requiredSize);
        boolean[] states = aggregated.v().allocated;
        double[] keys = aggregated.v().keys;
        int[] values2 = aggregated.v().values;
        boolean bl = false;
        while (var13_14 < states.length) {
            if (states[var13_14]) {
                ordered.add(new DoubleEntry(keys[var13_14], values2[var13_14]));
            }
            ++var13_14;
        }
        first.entries = ordered;
        first.missing = missing;
        first.total = total;
        aggregated.release();
        return first;
    }

    private void trimExcessEntries() {
        if (this.requiredSize >= this.entries.size()) {
            return;
        }
        if (this.entries instanceof List) {
            this.entries = ((List)this.entries).subList(0, this.requiredSize);
            return;
        }
        int i = 0;
        Iterator<DoubleEntry> iter2 = this.entries.iterator();
        while (iter2.hasNext()) {
            iter2.next();
            if (i++ < this.requiredSize) continue;
            iter2.remove();
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        builder.field(Fields._TYPE, "terms");
        builder.field(Fields.MISSING, this.missing);
        builder.field(Fields.TOTAL, this.total);
        builder.field(Fields.OTHER, this.getOtherCount());
        builder.startArray(Fields.TERMS);
        for (DoubleEntry entry2 : this.entries) {
            builder.startObject();
            builder.field(Fields.TERM, entry2.term);
            builder.field(Fields.COUNT, entry2.getCount());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static InternalDoubleTermsFacet readTermsFacet(StreamInput in) throws IOException {
        InternalDoubleTermsFacet facet = new InternalDoubleTermsFacet();
        facet.readFrom(in);
        return facet;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.comparatorType = TermsFacet.ComparatorType.fromId(in.readByte());
        this.requiredSize = in.readVInt();
        this.missing = in.readVLong();
        this.total = in.readVLong();
        int size2 = in.readVInt();
        this.entries = new ArrayList<DoubleEntry>(size2);
        for (int i = 0; i < size2; ++i) {
            this.entries.add(new DoubleEntry(in.readDouble(), in.readVInt()));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeByte(this.comparatorType.id());
        out.writeVInt(this.requiredSize);
        out.writeVLong(this.missing);
        out.writeVLong(this.total);
        out.writeVInt(this.entries.size());
        for (DoubleEntry entry2 : this.entries) {
            out.writeDouble(entry2.term);
            out.writeVInt(entry2.getCount());
        }
    }

    static final class Fields {
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString MISSING = new XContentBuilderString("missing");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString OTHER = new XContentBuilderString("other");
        static final XContentBuilderString TERMS = new XContentBuilderString("terms");
        static final XContentBuilderString TERM = new XContentBuilderString("term");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");

        Fields() {
        }
    }

    public static class DoubleEntry
    implements TermsFacet.Entry {
        double term;
        int count;

        public DoubleEntry(double term, int count2) {
            this.term = term;
            this.count = count2;
        }

        @Override
        public Text getTerm() {
            return new StringText(Double.toString(this.term));
        }

        @Override
        public Number getTermAsNumber() {
            return this.term;
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public int compareTo(TermsFacet.Entry o) {
            double anotherVal = ((DoubleEntry)o).term;
            if (this.term < anotherVal) {
                return -1;
            }
            if (this.term == anotherVal) {
                int i = this.count - o.getCount();
                if (i == 0) {
                    i = System.identityHashCode(this) - System.identityHashCode(o);
                }
                return i;
            }
            return 1;
        }
    }
}

