/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticSearchParseException;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.FacetParser;
import org.elasticsearch.search.facet.terms.InternalTermsFacet;
import org.elasticsearch.search.facet.terms.TermsFacet;
import org.elasticsearch.search.facet.terms.doubles.TermsDoubleFacetExecutor;
import org.elasticsearch.search.facet.terms.index.IndexNameFacetExecutor;
import org.elasticsearch.search.facet.terms.longs.TermsLongFacetExecutor;
import org.elasticsearch.search.facet.terms.strings.FieldsTermsStringFacetExecutor;
import org.elasticsearch.search.facet.terms.strings.ScriptTermsStringFieldFacetExecutor;
import org.elasticsearch.search.facet.terms.strings.TermsStringFacetExecutor;
import org.elasticsearch.search.facet.terms.strings.TermsStringOrdinalsFacetExecutor;
import org.elasticsearch.search.facet.terms.unmapped.UnmappedFieldExecutor;
import org.elasticsearch.search.internal.SearchContext;

public class TermsFacetParser
extends AbstractComponent
implements FacetParser {
    private final int ordinalsCacheAbove;

    @Inject
    public TermsFacetParser(Settings settings) {
        super(settings);
        InternalTermsFacet.registerStreams();
        this.ordinalsCacheAbove = this.componentSettings.getAsInt("ordinals_cache_above", (Integer)10000);
    }

    @Override
    public String[] types() {
        return new String[]{"terms"};
    }

    @Override
    public FacetExecutor.Mode defaultMainMode() {
        return FacetExecutor.Mode.COLLECTOR;
    }

    @Override
    public FacetExecutor.Mode defaultGlobalMode() {
        return FacetExecutor.Mode.COLLECTOR;
    }

    @Override
    public FacetExecutor parse(String facetName, XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token2;
        String field2 = null;
        int size2 = 10;
        int shardSize = -1;
        String[] fieldsNames = null;
        ImmutableSet<BytesRef> excluded = ImmutableSet.of();
        String regex = null;
        String regexFlags = null;
        TermsFacet.ComparatorType comparatorType = TermsFacet.ComparatorType.COUNT;
        String scriptLang = null;
        String script = null;
        Map<String, Object> params = null;
        boolean allTerms = false;
        String executionHint = null;
        String currentFieldName = null;
        while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token2 == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token2 == XContentParser.Token.START_OBJECT) {
                if ("params".equals(currentFieldName)) {
                    params = parser.map();
                    continue;
                }
                throw new ElasticSearchParseException("unknown parameter [" + currentFieldName + "] while parsing terms facet [" + facetName + "]");
            }
            if (token2 == XContentParser.Token.START_ARRAY) {
                if ("exclude".equals(currentFieldName)) {
                    ImmutableSet.Builder builder = ImmutableSet.builder();
                    while ((token2 = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        builder.add(parser.bytes());
                    }
                    excluded = builder.build();
                    continue;
                }
                if ("fields".equals(currentFieldName)) {
                    ArrayList<String> fields = Lists.newArrayListWithCapacity(4);
                    while ((token2 = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        fields.add(parser.text());
                    }
                    fieldsNames = fields.toArray(new String[fields.size()]);
                    continue;
                }
                throw new ElasticSearchParseException("unknown parameter [" + currentFieldName + "] while parsing terms facet [" + facetName + "]");
            }
            if (!token2.isValue()) continue;
            if ("field".equals(currentFieldName)) {
                field2 = parser.text();
                continue;
            }
            if ("script_field".equals(currentFieldName) || "scriptField".equals(currentFieldName)) {
                script = parser.text();
                continue;
            }
            if ("size".equals(currentFieldName)) {
                size2 = parser.intValue();
                continue;
            }
            if ("shard_size".equals(currentFieldName)) {
                shardSize = parser.intValue();
                continue;
            }
            if ("all_terms".equals(currentFieldName) || "allTerms".equals(currentFieldName)) {
                allTerms = parser.booleanValue();
                continue;
            }
            if ("regex".equals(currentFieldName)) {
                regex = parser.text();
                continue;
            }
            if ("regex_flags".equals(currentFieldName) || "regexFlags".equals(currentFieldName)) {
                regexFlags = parser.text();
                continue;
            }
            if ("order".equals(currentFieldName) || "comparator".equals(currentFieldName)) {
                comparatorType = TermsFacet.ComparatorType.fromString(parser.text());
                continue;
            }
            if ("script".equals(currentFieldName)) {
                script = parser.text();
                continue;
            }
            if ("lang".equals(currentFieldName)) {
                scriptLang = parser.text();
                continue;
            }
            if ("execution_hint".equals(currentFieldName) || "executionHint".equals(currentFieldName)) {
                executionHint = parser.textOrNull();
                continue;
            }
            throw new ElasticSearchParseException("unknown parameter [" + currentFieldName + "] while parsing terms facet [" + facetName + "]");
        }
        if ("_index".equals(field2)) {
            return new IndexNameFacetExecutor(context.shardTarget().index(), comparatorType, size2);
        }
        if (fieldsNames != null && fieldsNames.length == 1) {
            field2 = fieldsNames[0];
            fieldsNames = null;
        }
        Pattern pattern = null;
        if (regex != null) {
            pattern = Regex.compile(regex, regexFlags);
        }
        SearchScript searchScript = null;
        if (script != null) {
            searchScript = context.scriptService().search(context.lookup(), scriptLang, script, params);
        }
        if (shardSize < size2) {
            shardSize = size2;
        }
        if (fieldsNames != null) {
            ArrayList<FieldMapper> mappers = new ArrayList<FieldMapper>(fieldsNames.length);
            for (int i = 0; i < fieldsNames.length; ++i) {
                FieldMapper mapper = context.smartNameFieldMapper(fieldsNames[i]);
                if (mapper == null) continue;
                mappers.add(mapper);
            }
            if (mappers.isEmpty()) {
                return new UnmappedFieldExecutor(size2, comparatorType);
            }
            return new FieldsTermsStringFacetExecutor(mappers.toArray(new FieldMapper[mappers.size()]), size2, shardSize, comparatorType, allTerms, context, excluded, pattern, searchScript);
        }
        if (field2 == null && script != null) {
            return new ScriptTermsStringFieldFacetExecutor(size2, shardSize, comparatorType, context, excluded, pattern, scriptLang, script, params, context.cacheRecycler());
        }
        if (field2 == null) {
            throw new ElasticSearchParseException("terms facet [" + facetName + "] must have a field, fields or script parameter");
        }
        FieldMapper fieldMapper = context.smartNameFieldMapper(field2);
        if (fieldMapper == null) {
            return new UnmappedFieldExecutor(size2, comparatorType);
        }
        Object indexFieldData = context.fieldData().getForField(fieldMapper);
        if (indexFieldData instanceof IndexNumericFieldData) {
            IndexNumericFieldData indexNumericFieldData = (IndexNumericFieldData)indexFieldData;
            if (indexNumericFieldData.getNumericType().isFloatingPoint()) {
                return new TermsDoubleFacetExecutor(indexNumericFieldData, size2, shardSize, comparatorType, allTerms, context, excluded, searchScript, context.cacheRecycler());
            }
            return new TermsLongFacetExecutor(indexNumericFieldData, size2, shardSize, comparatorType, allTerms, context, excluded, searchScript, context.cacheRecycler());
        }
        if (script != null || "map".equals(executionHint)) {
            return new TermsStringFacetExecutor((IndexFieldData)indexFieldData, size2, shardSize, comparatorType, allTerms, context, excluded, pattern, searchScript);
        }
        if (indexFieldData instanceof IndexFieldData.WithOrdinals) {
            return new TermsStringOrdinalsFacetExecutor((IndexFieldData.WithOrdinals)indexFieldData, size2, shardSize, comparatorType, allTerms, context, excluded, pattern, this.ordinalsCacheAbove);
        }
        return new TermsStringFacetExecutor((IndexFieldData)indexFieldData, size2, shardSize, comparatorType, allTerms, context, excluded, pattern, searchScript);
    }
}

