/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilderException;
import org.elasticsearch.search.facet.FacetBuilder;
import org.elasticsearch.search.facet.terms.TermsFacet;

public class TermsFacetBuilder
extends FacetBuilder {
    private String fieldName;
    private String[] fieldsNames;
    private int size = 10;
    private int shardSize = -1;
    private Boolean allTerms;
    private Object[] exclude;
    private String regex;
    private int regexFlags = 0;
    private TermsFacet.ComparatorType comparatorType;
    private String script;
    private String lang;
    private Map<String, Object> params;
    String executionHint;

    public TermsFacetBuilder(String name) {
        super(name);
    }

    @Override
    public TermsFacetBuilder global(boolean global) {
        super.global(global);
        return this;
    }

    @Override
    public TermsFacetBuilder facetFilter(FilterBuilder filter2) {
        this.facetFilter = filter2;
        return this;
    }

    @Override
    public TermsFacetBuilder nested(String nested) {
        this.nested = nested;
        return this;
    }

    public TermsFacetBuilder field(String field2) {
        this.fieldName = field2;
        return this;
    }

    public TermsFacetBuilder fields(String ... fields) {
        this.fieldsNames = fields;
        return this;
    }

    public TermsFacetBuilder scriptField(String scriptField) {
        this.script = scriptField;
        return this;
    }

    public TermsFacetBuilder exclude(Object ... exclude) {
        this.exclude = exclude;
        return this;
    }

    public TermsFacetBuilder size(int size2) {
        this.size = size2;
        return this;
    }

    public TermsFacetBuilder shardSize(int shardSize) {
        this.shardSize = shardSize;
        return this;
    }

    public TermsFacetBuilder regex(String regex) {
        return this.regex(regex, 0);
    }

    public TermsFacetBuilder regex(String regex, int flags) {
        this.regex = regex;
        this.regexFlags = flags;
        return this;
    }

    public TermsFacetBuilder order(TermsFacet.ComparatorType comparatorType) {
        this.comparatorType = comparatorType;
        return this;
    }

    public TermsFacetBuilder script(String script) {
        this.script = script;
        return this;
    }

    public TermsFacetBuilder lang(String lang) {
        this.lang = lang;
        return this;
    }

    public TermsFacetBuilder executionHint(String executionHint) {
        this.executionHint = executionHint;
        return this;
    }

    public TermsFacetBuilder param(String name, Object value2) {
        if (this.params == null) {
            this.params = Maps.newHashMap();
        }
        this.params.put(name, value2);
        return this;
    }

    public TermsFacetBuilder allTerms(boolean allTerms) {
        this.allTerms = allTerms;
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.fieldName == null && this.fieldsNames == null && this.script == null) {
            throw new SearchSourceBuilderException("field/fields/script must be set on terms facet for facet [" + this.name + "]");
        }
        builder.startObject(this.name);
        builder.startObject("terms");
        if (this.fieldsNames != null) {
            if (this.fieldsNames.length == 1) {
                builder.field("field", this.fieldsNames[0]);
            } else {
                builder.field("fields", this.fieldsNames);
            }
        } else if (this.fieldName != null) {
            builder.field("field", this.fieldName);
        }
        builder.field("size", this.size);
        if (this.shardSize > this.size) {
            builder.field("shard_size", this.shardSize);
        }
        if (this.exclude != null) {
            builder.startArray("exclude");
            for (Object ex : this.exclude) {
                builder.value(ex);
            }
            builder.endArray();
        }
        if (this.regex != null) {
            builder.field("regex", this.regex);
            if (this.regexFlags != 0) {
                builder.field("regex_flags", Regex.flagsToString(this.regexFlags));
            }
        }
        if (this.comparatorType != null) {
            builder.field("order", this.comparatorType.name().toLowerCase(Locale.ROOT));
        }
        if (this.allTerms != null) {
            builder.field("all_terms", (Object)this.allTerms);
        }
        if (this.script != null) {
            builder.field("script", this.script);
            if (this.lang != null) {
                builder.field("lang", this.lang);
            }
            if (this.params != null) {
                builder.field("params", this.params);
            }
        }
        if (this.executionHint != null) {
            builder.field("execution_hint", this.executionHint);
        }
        builder.endObject();
        this.addFilterFacetAndGlobal(builder, params);
        builder.endObject();
        return builder;
    }
}

