/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.statistical;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.search.facet.DoubleFacetAggregatorBase;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.statistical.InternalStatisticalFacet;
import org.elasticsearch.search.internal.SearchContext;

public class StatisticalFieldsFacetExecutor
extends FacetExecutor {
    private final IndexNumericFieldData[] indexFieldDatas;
    double min = Double.POSITIVE_INFINITY;
    double max = Double.NEGATIVE_INFINITY;
    double total = 0.0;
    double sumOfSquares = 0.0;
    long count;
    int missing;

    public StatisticalFieldsFacetExecutor(IndexNumericFieldData[] indexFieldDatas, SearchContext context) {
        this.indexFieldDatas = indexFieldDatas;
    }

    @Override
    public Collector collector() {
        return new Collector();
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        return new InternalStatisticalFacet(facetName, this.min, this.max, this.total, this.sumOfSquares, this.count);
    }

    public static class StatsProc
    extends DoubleFacetAggregatorBase {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        double sum = 0.0;
        double sumOfSquares = 0.0;
        long count;
        int missing;

        @Override
        public void onValue(int docId, double value2) {
            if (value2 < this.min) {
                this.min = value2;
            }
            if (value2 > this.max) {
                this.max = value2;
            }
            this.sumOfSquares += value2 * value2;
            this.sum += value2;
            ++this.count;
        }
    }

    class Collector
    extends FacetExecutor.Collector {
        private final StatsProc statsProc = new StatsProc();
        private DoubleValues[] values;

        public Collector() {
            this.values = new DoubleValues[StatisticalFieldsFacetExecutor.this.indexFieldDatas.length];
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            for (int i = 0; i < StatisticalFieldsFacetExecutor.this.indexFieldDatas.length; ++i) {
                this.values[i] = StatisticalFieldsFacetExecutor.this.indexFieldDatas[i].load(context).getDoubleValues();
            }
        }

        @Override
        public void collect(int doc) throws IOException {
            for (DoubleValues value2 : this.values) {
                this.statsProc.onDoc(doc, value2);
            }
        }

        @Override
        public void postCollection() {
            StatisticalFieldsFacetExecutor.this.min = this.statsProc.min;
            StatisticalFieldsFacetExecutor.this.max = this.statsProc.max;
            StatisticalFieldsFacetExecutor.this.total = this.statsProc.sum;
            StatisticalFieldsFacetExecutor.this.sumOfSquares = this.statsProc.sumOfSquares;
            StatisticalFieldsFacetExecutor.this.count = this.statsProc.count;
            StatisticalFieldsFacetExecutor.this.missing = this.statsProc.missing;
        }
    }
}

