/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.statistical;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.FacetParser;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.statistical.InternalStatisticalFacet;
import org.elasticsearch.search.facet.statistical.ScriptStatisticalFacetExecutor;
import org.elasticsearch.search.facet.statistical.StatisticalFacetExecutor;
import org.elasticsearch.search.facet.statistical.StatisticalFieldsFacetExecutor;
import org.elasticsearch.search.internal.SearchContext;

public class StatisticalFacetParser
extends AbstractComponent
implements FacetParser {
    @Inject
    public StatisticalFacetParser(Settings settings) {
        super(settings);
        InternalStatisticalFacet.registerStreams();
    }

    @Override
    public String[] types() {
        return new String[]{"statistical"};
    }

    @Override
    public FacetExecutor.Mode defaultMainMode() {
        return FacetExecutor.Mode.COLLECTOR;
    }

    @Override
    public FacetExecutor.Mode defaultGlobalMode() {
        return FacetExecutor.Mode.COLLECTOR;
    }

    @Override
    public FacetExecutor parse(String facetName, XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token2;
        String field2 = null;
        String[] fieldsNames = null;
        String script = null;
        String scriptLang = null;
        Map<String, Object> params = null;
        String currentFieldName = null;
        while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token2 == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token2 == XContentParser.Token.START_OBJECT) {
                if (!"params".equals(currentFieldName)) continue;
                params = parser.map();
                continue;
            }
            if (token2 == XContentParser.Token.START_ARRAY) {
                if (!"fields".equals(currentFieldName)) continue;
                ArrayList<String> fields = Lists.newArrayListWithCapacity(4);
                while ((token2 = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    fields.add(parser.text());
                }
                fieldsNames = fields.toArray(new String[fields.size()]);
                continue;
            }
            if (!token2.isValue()) continue;
            if ("field".equals(currentFieldName)) {
                field2 = parser.text();
                continue;
            }
            if ("script".equals(currentFieldName)) {
                script = parser.text();
                continue;
            }
            if (!"lang".equals(currentFieldName)) continue;
            scriptLang = parser.text();
        }
        if (fieldsNames != null) {
            IndexNumericFieldData[] indexFieldDatas = new IndexNumericFieldData[fieldsNames.length];
            for (int i = 0; i < fieldsNames.length; ++i) {
                FieldMapper fieldMapper = context.smartNameFieldMapper((String)fieldsNames[i]);
                if (fieldMapper == null) {
                    throw new FacetPhaseExecutionException(facetName, "No mapping found for field [" + fieldsNames[i] + "]");
                }
                if (!(fieldMapper instanceof NumberFieldMapper)) {
                    throw new FacetPhaseExecutionException(facetName, "field [" + field2 + "] isn't a number field, but a " + fieldMapper.fieldDataType().getType());
                }
                indexFieldDatas[i] = (IndexNumericFieldData)context.fieldData().getForField(fieldMapper);
            }
            return new StatisticalFieldsFacetExecutor(indexFieldDatas, context);
        }
        if (script == null && field2 == null) {
            throw new FacetPhaseExecutionException(facetName, "statistical facet requires either [script] or [field] to be set");
        }
        if (field2 != null) {
            FieldMapper fieldMapper = context.smartNameFieldMapper(field2);
            if (fieldMapper == null) {
                throw new FacetPhaseExecutionException(facetName, "No mapping found for field [" + field2 + "]");
            }
            if (!(fieldMapper instanceof NumberFieldMapper)) {
                throw new FacetPhaseExecutionException(facetName, "field [" + field2 + "] isn't a number field, but a " + fieldMapper.fieldDataType().getType());
            }
            IndexNumericFieldData indexFieldData = (IndexNumericFieldData)context.fieldData().getForField(fieldMapper);
            return new StatisticalFacetExecutor(indexFieldData, context);
        }
        return new ScriptStatisticalFacetExecutor(scriptLang, script, params, context);
    }
}

