/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.statistical;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.search.facet.DoubleFacetAggregatorBase;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.statistical.InternalStatisticalFacet;
import org.elasticsearch.search.internal.SearchContext;

public class StatisticalFacetExecutor
extends FacetExecutor {
    private final IndexNumericFieldData indexFieldData;
    double min = Double.POSITIVE_INFINITY;
    double max = Double.NEGATIVE_INFINITY;
    double total = 0.0;
    double sumOfSquares = 0.0;
    long count;
    int missing;

    public StatisticalFacetExecutor(IndexNumericFieldData indexFieldData, SearchContext context) {
        this.indexFieldData = indexFieldData;
    }

    @Override
    public Collector collector() {
        return new Collector();
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        return new InternalStatisticalFacet(facetName, this.min, this.max, this.total, this.sumOfSquares, this.count);
    }

    public static class StatsProc
    extends DoubleFacetAggregatorBase {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        double total = 0.0;
        double sumOfSquares = 0.0;
        long count;
        int missing;

        @Override
        public void onValue(int docId, double value2) {
            if (value2 < this.min) {
                this.min = value2;
            }
            if (value2 > this.max) {
                this.max = value2;
            }
            this.sumOfSquares += value2 * value2;
            this.total += value2;
            ++this.count;
        }

        public final double min() {
            return this.min;
        }

        public final double max() {
            return this.max;
        }

        public final long count() {
            return this.count;
        }

        public final double sumOfSquares() {
            return this.sumOfSquares;
        }
    }

    class Collector
    extends FacetExecutor.Collector {
        private final StatsProc statsProc = new StatsProc();
        private DoubleValues values;

        Collector() {
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.values = StatisticalFacetExecutor.this.indexFieldData.load(context).getDoubleValues();
        }

        @Override
        public void collect(int doc) throws IOException {
            this.statsProc.onDoc(doc, this.values);
        }

        @Override
        public void postCollection() {
            StatisticalFacetExecutor.this.min = this.statsProc.min;
            StatisticalFacetExecutor.this.max = this.statsProc.max;
            StatisticalFacetExecutor.this.total = this.statsProc.total;
            StatisticalFacetExecutor.this.sumOfSquares = this.statsProc.sumOfSquares;
            StatisticalFacetExecutor.this.count = this.statsProc.count;
            StatisticalFacetExecutor.this.missing = this.statsProc.missing;
        }
    }
}

