/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.statistical;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.statistical.InternalStatisticalFacet;
import org.elasticsearch.search.internal.SearchContext;

public class ScriptStatisticalFacetExecutor
extends FacetExecutor {
    private final SearchScript script;
    private double min = Double.POSITIVE_INFINITY;
    private double max = Double.NEGATIVE_INFINITY;
    private double total = 0.0;
    private double sumOfSquares = 0.0;
    private long count;

    public ScriptStatisticalFacetExecutor(String scriptLang, String script, Map<String, Object> params, SearchContext context) {
        this.script = context.scriptService().search(context.lookup(), scriptLang, script, params);
    }

    @Override
    public Collector collector() {
        return new Collector();
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        return new InternalStatisticalFacet(facetName, this.min, this.max, this.total, this.sumOfSquares, this.count);
    }

    class Collector
    extends FacetExecutor.Collector {
        private double min = Double.POSITIVE_INFINITY;
        private double max = Double.NEGATIVE_INFINITY;
        private double total = 0.0;
        private double sumOfSquares = 0.0;
        private long count;

        Collector() {
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            ScriptStatisticalFacetExecutor.this.script.setScorer(scorer);
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            ScriptStatisticalFacetExecutor.this.script.setNextReader(context);
        }

        @Override
        public void collect(int doc) throws IOException {
            ScriptStatisticalFacetExecutor.this.script.setNextDocId(doc);
            double value2 = ScriptStatisticalFacetExecutor.this.script.runAsDouble();
            if (value2 < this.min) {
                this.min = value2;
            }
            if (value2 > this.max) {
                this.max = value2;
            }
            this.sumOfSquares += value2 * value2;
            this.total += value2;
            ++this.count;
        }

        @Override
        public void postCollection() {
            ScriptStatisticalFacetExecutor.this.min = this.min;
            ScriptStatisticalFacetExecutor.this.max = this.max;
            ScriptStatisticalFacetExecutor.this.total = this.total;
            ScriptStatisticalFacetExecutor.this.sumOfSquares = this.sumOfSquares;
            ScriptStatisticalFacetExecutor.this.count = this.count;
        }
    }
}

