/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.statistical;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.statistical.StatisticalFacet;

public class InternalStatisticalFacet
extends InternalFacet
implements StatisticalFacet {
    private static final BytesReference STREAM_TYPE = new HashedBytesArray(Strings.toUTF8Bytes("statistical"));
    static InternalFacet.Stream STREAM = new InternalFacet.Stream(){

        @Override
        public Facet readFacet(StreamInput in) throws IOException {
            return InternalStatisticalFacet.readStatisticalFacet(in);
        }
    };
    private double min;
    private double max;
    private double total;
    private double sumOfSquares;
    private long count;

    public static void registerStreams() {
        InternalFacet.Streams.registerStream(STREAM, STREAM_TYPE);
    }

    @Override
    public BytesReference streamType() {
        return STREAM_TYPE;
    }

    private InternalStatisticalFacet() {
    }

    public InternalStatisticalFacet(String name, double min2, double max2, double total, double sumOfSquares, long count2) {
        super(name);
        this.min = min2;
        this.max = max2;
        this.total = total;
        this.sumOfSquares = sumOfSquares;
        this.count = count2;
    }

    @Override
    public String getType() {
        return "statistical";
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public double getTotal() {
        return this.total;
    }

    @Override
    public double getSumOfSquares() {
        return this.sumOfSquares;
    }

    @Override
    public double getMean() {
        if (this.count == 0L) {
            return 0.0;
        }
        return this.total / (double)this.count;
    }

    @Override
    public double getMin() {
        return this.min;
    }

    @Override
    public double getMax() {
        return this.max;
    }

    @Override
    public double getVariance() {
        return (this.sumOfSquares - this.total * this.total / (double)this.count) / (double)this.count;
    }

    @Override
    public double getStdDeviation() {
        return Math.sqrt(this.getVariance());
    }

    @Override
    public Facet reduce(InternalFacet.ReduceContext context) {
        List<Facet> facets = context.facets();
        if (facets.size() == 1) {
            return facets.get(0);
        }
        double min2 = Double.NaN;
        double max2 = Double.NaN;
        double total = 0.0;
        double sumOfSquares = 0.0;
        long count2 = 0L;
        for (Facet facet : facets) {
            InternalStatisticalFacet statsFacet = (InternalStatisticalFacet)facet;
            if (statsFacet.getMin() < min2 || Double.isNaN(min2)) {
                min2 = statsFacet.getMin();
            }
            if (statsFacet.getMax() > max2 || Double.isNaN(max2)) {
                max2 = statsFacet.getMax();
            }
            total += statsFacet.getTotal();
            sumOfSquares += statsFacet.getSumOfSquares();
            count2 += statsFacet.getCount();
        }
        return new InternalStatisticalFacet(this.getName(), min2, max2, total, sumOfSquares, count2);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        builder.field(Fields._TYPE, "statistical");
        builder.field(Fields.COUNT, this.getCount());
        builder.field(Fields.TOTAL, this.getTotal());
        builder.field(Fields.MIN, this.getMin());
        builder.field(Fields.MAX, this.getMax());
        builder.field(Fields.MEAN, this.getMean());
        builder.field(Fields.SUM_OF_SQUARES, this.getSumOfSquares());
        builder.field(Fields.VARIANCE, this.getVariance());
        builder.field(Fields.STD_DEVIATION, this.getStdDeviation());
        builder.endObject();
        return builder;
    }

    public static StatisticalFacet readStatisticalFacet(StreamInput in) throws IOException {
        InternalStatisticalFacet facet = new InternalStatisticalFacet();
        facet.readFrom(in);
        return facet;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.count = in.readVLong();
        this.total = in.readDouble();
        this.min = in.readDouble();
        this.max = in.readDouble();
        this.sumOfSquares = in.readDouble();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVLong(this.count);
        out.writeDouble(this.total);
        out.writeDouble(this.min);
        out.writeDouble(this.max);
        out.writeDouble(this.sumOfSquares);
    }

    static final class Fields {
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString MIN = new XContentBuilderString("min");
        static final XContentBuilderString MAX = new XContentBuilderString("max");
        static final XContentBuilderString MEAN = new XContentBuilderString("mean");
        static final XContentBuilderString SUM_OF_SQUARES = new XContentBuilderString("sum_of_squares");
        static final XContentBuilderString VARIANCE = new XContentBuilderString("variance");
        static final XContentBuilderString STD_DEVIATION = new XContentBuilderString("std_deviation");

        Fields() {
        }
    }
}

