/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.range;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.range.InternalRangeFacet;
import org.elasticsearch.search.facet.range.RangeFacet;
import org.elasticsearch.search.internal.SearchContext;

public class ScriptRangeFacetExecutor
extends FacetExecutor {
    final SearchScript keyScript;
    final SearchScript valueScript;
    private final RangeFacet.Entry[] entries;

    public ScriptRangeFacetExecutor(String scriptLang, String keyScript, String valueScript, Map<String, Object> params, RangeFacet.Entry[] entries, SearchContext context) {
        this.keyScript = context.scriptService().search(context.lookup(), scriptLang, keyScript, params);
        this.valueScript = context.scriptService().search(context.lookup(), scriptLang, valueScript, params);
        this.entries = entries;
    }

    @Override
    public Collector collector() {
        return new Collector();
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        return new InternalRangeFacet(facetName, this.entries);
    }

    class Collector
    extends FacetExecutor.Collector {
        Collector() {
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            ScriptRangeFacetExecutor.this.keyScript.setScorer(scorer);
            ScriptRangeFacetExecutor.this.valueScript.setScorer(scorer);
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            ScriptRangeFacetExecutor.this.keyScript.setNextReader(context);
            ScriptRangeFacetExecutor.this.valueScript.setNextReader(context);
        }

        @Override
        public void collect(int doc) throws IOException {
            ScriptRangeFacetExecutor.this.keyScript.setNextDocId(doc);
            ScriptRangeFacetExecutor.this.valueScript.setNextDocId(doc);
            double key = ScriptRangeFacetExecutor.this.keyScript.runAsDouble();
            double value2 = ScriptRangeFacetExecutor.this.valueScript.runAsDouble();
            for (RangeFacet.Entry entry2 : ScriptRangeFacetExecutor.this.entries) {
                if (!(key >= entry2.getFrom()) || !(key < entry2.getTo())) continue;
                ++entry2.count;
                ++entry2.totalCount;
                entry2.total += value2;
                if (value2 < entry2.min) {
                    entry2.min = value2;
                }
                if (!(value2 > entry2.max)) continue;
                entry2.max = value2;
            }
        }

        @Override
        public void postCollection() {
        }
    }
}

