/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.range;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilderException;
import org.elasticsearch.search.facet.FacetBuilder;

public class RangeFacetBuilder
extends FacetBuilder {
    private String keyFieldName;
    private String valueFieldName;
    private List<Entry> entries = Lists.newArrayList();

    public RangeFacetBuilder(String name) {
        super(name);
    }

    public RangeFacetBuilder field(String field2) {
        this.keyFieldName = field2;
        this.valueFieldName = field2;
        return this;
    }

    public RangeFacetBuilder keyField(String keyField) {
        this.keyFieldName = keyField;
        return this;
    }

    public RangeFacetBuilder valueField(String valueField) {
        this.valueFieldName = valueField;
        return this;
    }

    public RangeFacetBuilder addRange(double from2, double to2) {
        this.entries.add(new Entry(from2, to2));
        return this;
    }

    public RangeFacetBuilder addRange(String from2, String to2) {
        this.entries.add(new Entry(from2, to2));
        return this;
    }

    public RangeFacetBuilder addUnboundedTo(double from2) {
        this.entries.add(new Entry(from2, Double.POSITIVE_INFINITY));
        return this;
    }

    public RangeFacetBuilder addUnboundedTo(String from2) {
        this.entries.add(new Entry(from2, null));
        return this;
    }

    public RangeFacetBuilder addUnboundedFrom(double to2) {
        this.entries.add(new Entry(Double.NEGATIVE_INFINITY, to2));
        return this;
    }

    public RangeFacetBuilder addUnboundedFrom(String to2) {
        this.entries.add(new Entry(null, to2));
        return this;
    }

    @Override
    public RangeFacetBuilder global(boolean global) {
        super.global(global);
        return this;
    }

    @Override
    public RangeFacetBuilder facetFilter(FilterBuilder filter2) {
        this.facetFilter = filter2;
        return this;
    }

    @Override
    public RangeFacetBuilder nested(String nested) {
        this.nested = nested;
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.keyFieldName == null) {
            throw new SearchSourceBuilderException("field must be set on range facet for facet [" + this.name + "]");
        }
        if (this.entries.isEmpty()) {
            throw new SearchSourceBuilderException("at least one range must be defined for range facet [" + this.name + "]");
        }
        builder.startObject(this.name);
        builder.startObject("range");
        if (this.valueFieldName != null && !this.keyFieldName.equals(this.valueFieldName)) {
            builder.field("key_field", this.keyFieldName);
            builder.field("value_field", this.valueFieldName);
        } else {
            builder.field("field", this.keyFieldName);
        }
        builder.startArray("ranges");
        for (Entry entry2 : this.entries) {
            builder.startObject();
            if (entry2.fromAsString != null) {
                builder.field("from", entry2.fromAsString);
            } else if (!Double.isInfinite(entry2.from)) {
                builder.field("from", entry2.from);
            }
            if (entry2.toAsString != null) {
                builder.field("to", entry2.toAsString);
            } else if (!Double.isInfinite(entry2.to)) {
                builder.field("to", entry2.to);
            }
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        this.addFilterFacetAndGlobal(builder, params);
        builder.endObject();
        return builder;
    }

    static class Entry {
        double from = Double.NEGATIVE_INFINITY;
        double to = Double.POSITIVE_INFINITY;
        String fromAsString;
        String toAsString;

        Entry(String fromAsString, String toAsString) {
            this.fromAsString = fromAsString;
            this.toAsString = toAsString;
        }

        Entry(double from2, double to2) {
            this.from = from2;
            this.to = to2;
        }
    }
}

