/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.range;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.search.facet.DoubleFacetAggregatorBase;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.range.InternalRangeFacet;
import org.elasticsearch.search.facet.range.RangeFacet;
import org.elasticsearch.search.internal.SearchContext;

public class KeyValueRangeFacetExecutor
extends FacetExecutor {
    private final IndexNumericFieldData keyIndexFieldData;
    private final IndexNumericFieldData valueIndexFieldData;
    private final RangeFacet.Entry[] entries;

    public KeyValueRangeFacetExecutor(IndexNumericFieldData keyIndexFieldData, IndexNumericFieldData valueIndexFieldData, RangeFacet.Entry[] entries, SearchContext context) {
        this.entries = entries;
        this.keyIndexFieldData = keyIndexFieldData;
        this.valueIndexFieldData = valueIndexFieldData;
    }

    @Override
    public Collector collector() {
        return new Collector();
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        return new InternalRangeFacet(facetName, this.entries);
    }

    public static class RangeProc
    extends DoubleFacetAggregatorBase {
        private final RangeFacet.Entry[] entries;
        DoubleValues valueValues;

        public RangeProc(RangeFacet.Entry[] entries) {
            this.entries = entries;
        }

        @Override
        public void onValue(int docId, double value2) {
            for (RangeFacet.Entry entry2 : this.entries) {
                if (entry2.foundInDoc || !(value2 >= entry2.getFrom()) || !(value2 < entry2.getTo())) continue;
                entry2.foundInDoc = true;
                ++entry2.count;
                int seek = this.valueValues.setDocument(docId);
                for (int i = 0; i < seek; ++i) {
                    double valueValue = this.valueValues.nextValue();
                    entry2.total += valueValue;
                    entry2.min = Math.min(entry2.min, valueValue);
                    entry2.max = Math.max(entry2.max, valueValue);
                }
                entry2.totalCount += (long)seek;
            }
        }
    }

    class Collector
    extends FacetExecutor.Collector {
        private final RangeProc rangeProc;
        private DoubleValues keyValues;

        public Collector() {
            this.rangeProc = new RangeProc(KeyValueRangeFacetExecutor.this.entries);
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.keyValues = KeyValueRangeFacetExecutor.this.keyIndexFieldData.load(context).getDoubleValues();
            this.rangeProc.valueValues = KeyValueRangeFacetExecutor.this.valueIndexFieldData.load(context).getDoubleValues();
        }

        @Override
        public void collect(int doc) throws IOException {
            for (RangeFacet.Entry entry2 : KeyValueRangeFacetExecutor.this.entries) {
                entry2.foundInDoc = false;
            }
            this.rangeProc.onDoc(doc, this.keyValues);
        }

        @Override
        public void postCollection() {
        }
    }
}

