/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.range;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.range.RangeFacet;

public class InternalRangeFacet
extends InternalFacet
implements RangeFacet {
    private static final BytesReference STREAM_TYPE = new HashedBytesArray(Strings.toUTF8Bytes("range"));
    static InternalFacet.Stream STREAM = new InternalFacet.Stream(){

        @Override
        public Facet readFacet(StreamInput in) throws IOException {
            return InternalRangeFacet.readRangeFacet(in);
        }
    };
    RangeFacet.Entry[] entries;

    public static void registerStreams() {
        InternalFacet.Streams.registerStream(STREAM, STREAM_TYPE);
    }

    @Override
    public BytesReference streamType() {
        return STREAM_TYPE;
    }

    InternalRangeFacet() {
    }

    public InternalRangeFacet(String name, RangeFacet.Entry[] entries) {
        super(name);
        this.entries = entries;
    }

    @Override
    public String getType() {
        return "range";
    }

    @Override
    public List<RangeFacet.Entry> getEntries() {
        return ImmutableList.copyOf(this.entries);
    }

    @Override
    public Iterator<RangeFacet.Entry> iterator() {
        return this.getEntries().iterator();
    }

    @Override
    public Facet reduce(InternalFacet.ReduceContext context) {
        List<Facet> facets = context.facets();
        if (facets.size() == 1) {
            return facets.get(0);
        }
        InternalRangeFacet agg = null;
        for (Facet facet : facets) {
            InternalRangeFacet geoDistanceFacet = (InternalRangeFacet)facet;
            if (agg == null) {
                agg = geoDistanceFacet;
                continue;
            }
            for (int i = 0; i < geoDistanceFacet.entries.length; ++i) {
                RangeFacet.Entry aggEntry = agg.entries[i];
                RangeFacet.Entry currentEntry = geoDistanceFacet.entries[i];
                aggEntry.count += currentEntry.count;
                aggEntry.totalCount += currentEntry.totalCount;
                aggEntry.total += currentEntry.total;
                if (currentEntry.min < aggEntry.min) {
                    aggEntry.min = currentEntry.min;
                }
                if (!(currentEntry.max > aggEntry.max)) continue;
                aggEntry.max = currentEntry.max;
            }
        }
        return agg;
    }

    public static InternalRangeFacet readRangeFacet(StreamInput in) throws IOException {
        InternalRangeFacet facet = new InternalRangeFacet();
        facet.readFrom(in);
        return facet;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.entries = new RangeFacet.Entry[in.readVInt()];
        for (int i = 0; i < this.entries.length; ++i) {
            RangeFacet.Entry entry2 = new RangeFacet.Entry();
            entry2.from = in.readDouble();
            entry2.to = in.readDouble();
            if (in.readBoolean()) {
                entry2.fromAsString = in.readString();
            }
            if (in.readBoolean()) {
                entry2.toAsString = in.readString();
            }
            entry2.count = in.readVLong();
            entry2.totalCount = in.readVLong();
            entry2.total = in.readDouble();
            entry2.min = in.readDouble();
            entry2.max = in.readDouble();
            this.entries[i] = entry2;
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.entries.length);
        for (RangeFacet.Entry entry2 : this.entries) {
            out.writeDouble(entry2.from);
            out.writeDouble(entry2.to);
            if (entry2.fromAsString == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeString(entry2.fromAsString);
            }
            if (entry2.toAsString == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeString(entry2.toAsString);
            }
            out.writeVLong(entry2.count);
            out.writeVLong(entry2.totalCount);
            out.writeDouble(entry2.total);
            out.writeDouble(entry2.min);
            out.writeDouble(entry2.max);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        builder.field(Fields._TYPE, "range");
        builder.startArray(Fields.RANGES);
        for (RangeFacet.Entry entry2 : this.entries) {
            builder.startObject();
            if (!Double.isInfinite(entry2.from)) {
                builder.field(Fields.FROM, entry2.from);
            }
            if (entry2.fromAsString != null) {
                builder.field(Fields.FROM_STR, entry2.fromAsString);
            }
            if (!Double.isInfinite(entry2.to)) {
                builder.field(Fields.TO, entry2.to);
            }
            if (entry2.toAsString != null) {
                builder.field(Fields.TO_STR, entry2.toAsString);
            }
            builder.field(Fields.COUNT, entry2.getCount());
            if (entry2.getTotalCount() > 0L) {
                builder.field(Fields.MIN, entry2.getMin());
                builder.field(Fields.MAX, entry2.getMax());
            }
            builder.field(Fields.TOTAL_COUNT, entry2.getTotalCount());
            builder.field(Fields.TOTAL, entry2.getTotal());
            builder.field(Fields.MEAN, entry2.getMean());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString RANGES = new XContentBuilderString("ranges");
        static final XContentBuilderString FROM = new XContentBuilderString("from");
        static final XContentBuilderString FROM_STR = new XContentBuilderString("from_str");
        static final XContentBuilderString TO = new XContentBuilderString("to");
        static final XContentBuilderString TO_STR = new XContentBuilderString("to_str");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString TOTAL_COUNT = new XContentBuilderString("total_count");
        static final XContentBuilderString MEAN = new XContentBuilderString("mean");
        static final XContentBuilderString MIN = new XContentBuilderString("min");
        static final XContentBuilderString MAX = new XContentBuilderString("max");

        Fields() {
        }
    }
}

