/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.query;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.lucene.docset.AndDocIdSet;
import org.elasticsearch.common.lucene.docset.ContextDocIdSet;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.lucene.search.XConstantScoreQuery;
import org.elasticsearch.common.lucene.search.XFilteredQuery;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.query.InternalQueryFacet;

public class QueryFacetExecutor
extends FacetExecutor {
    private final Query query;
    private final Filter filter;
    long count = -1L;

    public QueryFacetExecutor(Query query) {
        this.query = query;
        Filter possibleFilter = this.extractFilterIfApplicable(query);
        this.filter = possibleFilter != null ? possibleFilter : new QueryWrapperFilter(query);
    }

    @Override
    public Collector collector() {
        return new Collector();
    }

    @Override
    public Post post() {
        return new Post();
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        return new InternalQueryFacet(facetName, this.count);
    }

    private Filter extractFilterIfApplicable(Query query) {
        if (query instanceof XFilteredQuery) {
            XFilteredQuery fQuery = (XFilteredQuery)query;
            if (Queries.isConstantMatchAllQuery(fQuery.getQuery())) {
                return fQuery.getFilter();
            }
        } else {
            ConstantScoreQuery constantScoreQuery;
            if (query instanceof XConstantScoreQuery) {
                return ((XConstantScoreQuery)query).getFilter();
            }
            if (query instanceof ConstantScoreQuery && (constantScoreQuery = (ConstantScoreQuery)query).getFilter() != null) {
                return constantScoreQuery.getFilter();
            }
        }
        return null;
    }

    class Collector
    extends FacetExecutor.Collector {
        private long count = 0L;
        private Bits bits;

        Collector() {
        }

        @Override
        public void collect(int doc) throws IOException {
            if (this.bits.get(doc)) {
                ++this.count;
            }
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.bits = DocIdSets.toSafeBits(context.reader(), QueryFacetExecutor.this.filter.getDocIdSet(context, context.reader().getLiveDocs()));
        }

        @Override
        public void postCollection() {
            this.bits = null;
            QueryFacetExecutor.this.count = this.count;
        }
    }

    class Post
    extends FacetExecutor.Post {
        Post() {
        }

        @Override
        public void executePost(List<ContextDocIdSet> docSets) throws IOException {
            int count2 = 0;
            for (ContextDocIdSet entry2 : docSets) {
                DocIdSet filteredDocIdSet = QueryFacetExecutor.this.filter.getDocIdSet(entry2.context, entry2.context.reader().getLiveDocs());
                if (filteredDocIdSet == null || entry2.docSet == null) continue;
                DocIdSetIterator iter2 = new AndDocIdSet(new DocIdSet[]{entry2.docSet, filteredDocIdSet}).iterator();
                while (iter2.nextDoc() != Integer.MAX_VALUE) {
                    ++count2;
                }
            }
            QueryFacetExecutor.this.count = count2;
        }
    }
}

