/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.histogram;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.common.hppc.LongObjectOpenHashMap;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.DoubleFacetAggregatorBase;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.histogram.HistogramFacet;
import org.elasticsearch.search.facet.histogram.InternalFullHistogramFacet;
import org.elasticsearch.search.internal.SearchContext;

public class ValueScriptHistogramFacetExecutor
extends FacetExecutor {
    private final IndexNumericFieldData indexFieldData;
    private final HistogramFacet.ComparatorType comparatorType;
    final SearchScript valueScript;
    final long interval;
    final Recycler.V<LongObjectOpenHashMap<InternalFullHistogramFacet.FullEntry>> entries;

    public ValueScriptHistogramFacetExecutor(IndexNumericFieldData indexFieldData, String scriptLang, String valueScript, Map<String, Object> params, long interval, HistogramFacet.ComparatorType comparatorType, SearchContext context) {
        this.comparatorType = comparatorType;
        this.indexFieldData = indexFieldData;
        this.interval = interval;
        this.valueScript = context.scriptService().search(context.lookup(), scriptLang, valueScript, params);
        this.entries = context.cacheRecycler().longObjectMap(-1);
    }

    @Override
    public Collector collector() {
        return new Collector();
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        ArrayList<InternalFullHistogramFacet.FullEntry> entries1 = new ArrayList<InternalFullHistogramFacet.FullEntry>(this.entries.v().size());
        boolean[] states = this.entries.v().allocated;
        VType[] values2 = this.entries.v().values;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            InternalFullHistogramFacet.FullEntry value2 = (InternalFullHistogramFacet.FullEntry)values2[i];
            entries1.add(value2);
        }
        this.entries.release();
        return new InternalFullHistogramFacet(facetName, this.comparatorType, entries1);
    }

    public static long bucket(double value2, long interval) {
        return (long)(value2 / (double)interval) * interval;
    }

    public static class HistogramProc
    extends DoubleFacetAggregatorBase {
        private final long interval;
        private final SearchScript valueScript;
        final LongObjectOpenHashMap<InternalFullHistogramFacet.FullEntry> entries;

        public HistogramProc(long interval, SearchScript valueScript, LongObjectOpenHashMap<InternalFullHistogramFacet.FullEntry> entries) {
            this.interval = interval;
            this.valueScript = valueScript;
            this.entries = entries;
        }

        @Override
        public void onValue(int docId, double value2) {
            this.valueScript.setNextDocId(docId);
            long bucket = ValueScriptHistogramFacetExecutor.bucket(value2, this.interval);
            double scriptValue = this.valueScript.runAsDouble();
            InternalFullHistogramFacet.FullEntry entry2 = this.entries.get(bucket);
            if (entry2 == null) {
                entry2 = new InternalFullHistogramFacet.FullEntry(bucket, 1L, scriptValue, scriptValue, 1L, scriptValue);
                this.entries.put(bucket, entry2);
            } else {
                ++entry2.count;
                ++entry2.totalCount;
                entry2.total += scriptValue;
                if (scriptValue < entry2.min) {
                    entry2.min = scriptValue;
                }
                if (scriptValue > entry2.max) {
                    entry2.max = scriptValue;
                }
            }
        }
    }

    class Collector
    extends FacetExecutor.Collector {
        private DoubleValues values;
        private final HistogramProc histoProc;

        public Collector() {
            this.histoProc = new HistogramProc(ValueScriptHistogramFacetExecutor.this.interval, ValueScriptHistogramFacetExecutor.this.valueScript, ValueScriptHistogramFacetExecutor.this.entries.v());
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            ValueScriptHistogramFacetExecutor.this.valueScript.setScorer(scorer);
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.values = ValueScriptHistogramFacetExecutor.this.indexFieldData.load(context).getDoubleValues();
            ValueScriptHistogramFacetExecutor.this.valueScript.setNextReader(context);
        }

        @Override
        public void collect(int doc) throws IOException {
            this.histoProc.onDoc(doc, this.values);
        }

        @Override
        public void postCollection() {
        }
    }
}

