/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.histogram;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.common.hppc.LongObjectOpenHashMap;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.search.facet.DoubleFacetAggregatorBase;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.histogram.FullHistogramFacetExecutor;
import org.elasticsearch.search.facet.histogram.HistogramFacet;
import org.elasticsearch.search.facet.histogram.InternalFullHistogramFacet;
import org.elasticsearch.search.internal.SearchContext;

public class ValueHistogramFacetExecutor
extends FacetExecutor {
    private final IndexNumericFieldData keyIndexFieldData;
    private final IndexNumericFieldData valueIndexFieldData;
    private final HistogramFacet.ComparatorType comparatorType;
    private final long interval;
    final Recycler.V<LongObjectOpenHashMap<InternalFullHistogramFacet.FullEntry>> entries;

    public ValueHistogramFacetExecutor(IndexNumericFieldData keyIndexFieldData, IndexNumericFieldData valueIndexFieldData, long interval, HistogramFacet.ComparatorType comparatorType, SearchContext context) {
        this.comparatorType = comparatorType;
        this.keyIndexFieldData = keyIndexFieldData;
        this.valueIndexFieldData = valueIndexFieldData;
        this.interval = interval;
        this.entries = context.cacheRecycler().longObjectMap(-1);
    }

    @Override
    public Collector collector() {
        return new Collector();
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        ArrayList<InternalFullHistogramFacet.FullEntry> entries1 = new ArrayList<InternalFullHistogramFacet.FullEntry>(this.entries.v().size());
        boolean[] states = this.entries.v().allocated;
        VType[] values2 = this.entries.v().values;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            InternalFullHistogramFacet.FullEntry value2 = (InternalFullHistogramFacet.FullEntry)values2[i];
            entries1.add(value2);
        }
        this.entries.release();
        return new InternalFullHistogramFacet(facetName, this.comparatorType, entries1);
    }

    public static final class HistogramProc
    extends DoubleFacetAggregatorBase {
        final long interval;
        final LongObjectOpenHashMap<InternalFullHistogramFacet.FullEntry> entries;
        DoubleValues valueValues;
        final ValueAggregator valueAggregator = new ValueAggregator();

        public HistogramProc(long interval, LongObjectOpenHashMap<InternalFullHistogramFacet.FullEntry> entries) {
            this.interval = interval;
            this.entries = entries;
        }

        @Override
        public void onValue(int docId, double value2) {
            long bucket = FullHistogramFacetExecutor.bucket(value2, this.interval);
            InternalFullHistogramFacet.FullEntry entry2 = this.entries.get(bucket);
            if (entry2 == null) {
                entry2 = new InternalFullHistogramFacet.FullEntry(bucket, 0L, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 0L, 0.0);
                this.entries.put(bucket, entry2);
            }
            ++entry2.count;
            this.valueAggregator.entry = entry2;
            this.valueAggregator.onDoc(docId, this.valueValues);
        }

        public static final class ValueAggregator
        extends DoubleFacetAggregatorBase {
            InternalFullHistogramFacet.FullEntry entry;

            @Override
            public void onValue(int docId, double value2) {
                ++this.entry.totalCount;
                this.entry.total += value2;
                if (value2 < this.entry.min) {
                    this.entry.min = value2;
                }
                if (value2 > this.entry.max) {
                    this.entry.max = value2;
                }
            }
        }
    }

    class Collector
    extends FacetExecutor.Collector {
        private final HistogramProc histoProc;
        private DoubleValues keyValues;

        public Collector() {
            this.histoProc = new HistogramProc(ValueHistogramFacetExecutor.this.interval, ValueHistogramFacetExecutor.this.entries.v());
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.keyValues = ValueHistogramFacetExecutor.this.keyIndexFieldData.load(context).getDoubleValues();
            this.histoProc.valueValues = ValueHistogramFacetExecutor.this.valueIndexFieldData.load(context).getDoubleValues();
        }

        @Override
        public void collect(int doc) throws IOException {
            this.histoProc.onDoc(doc, this.keyValues);
        }

        @Override
        public void postCollection() {
        }
    }
}

