/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.histogram;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.histogram.HistogramFacet;
import org.elasticsearch.search.facet.histogram.InternalHistogramFacet;

public class InternalFullHistogramFacet
extends InternalHistogramFacet {
    private static final BytesReference STREAM_TYPE = new HashedBytesArray(Strings.toUTF8Bytes("fHistogram"));
    static InternalFacet.Stream STREAM = new InternalFacet.Stream(){

        @Override
        public Facet readFacet(StreamInput in) throws IOException {
            return InternalFullHistogramFacet.readHistogramFacet(in);
        }
    };
    private HistogramFacet.ComparatorType comparatorType;
    List<FullEntry> entries;

    public static void registerStreams() {
        InternalFacet.Streams.registerStream(STREAM, STREAM_TYPE);
    }

    @Override
    public BytesReference streamType() {
        return STREAM_TYPE;
    }

    InternalFullHistogramFacet() {
    }

    InternalFullHistogramFacet(String name) {
        super(name);
    }

    public InternalFullHistogramFacet(String name, HistogramFacet.ComparatorType comparatorType, List<FullEntry> entries) {
        super(name);
        this.comparatorType = comparatorType;
        this.entries = entries;
    }

    public List<FullEntry> getEntries() {
        return this.entries;
    }

    @Override
    public Iterator<HistogramFacet.Entry> iterator() {
        return this.getEntries().iterator();
    }

    @Override
    public Facet reduce(InternalFacet.ReduceContext context) {
        FullEntry value2;
        List<Facet> facets = context.facets();
        if (facets.size() == 1) {
            InternalFullHistogramFacet internalFacet = (InternalFullHistogramFacet)facets.get(0);
            List<FullEntry> entries = internalFacet.getEntries();
            CollectionUtil.timSort(entries, this.comparatorType.comparator());
            return internalFacet;
        }
        Recycler.V map2 = context.cacheRecycler().longObjectMap(-1);
        for (Facet facet : facets) {
            InternalFullHistogramFacet histoFacet = (InternalFullHistogramFacet)facet;
            for (FullEntry fullEntry : histoFacet.entries) {
                FullEntry current = (FullEntry)map2.v().get(fullEntry.key);
                if (current != null) {
                    current.count += fullEntry.count;
                    current.total += fullEntry.total;
                    current.totalCount += fullEntry.totalCount;
                    if (fullEntry.min < current.min) {
                        current.min = fullEntry.min;
                    }
                    if (!(fullEntry.max > current.max)) continue;
                    current.max = fullEntry.max;
                    continue;
                }
                map2.v().put(fullEntry.key, fullEntry);
            }
        }
        Object[] values2 = map2.v().values().toArray();
        Arrays.sort(values2, this.comparatorType.comparator());
        ArrayList<FullEntry> ordered = new ArrayList<FullEntry>(map2.v().size());
        for (int i = 0; i < map2.v().size() && (value2 = (FullEntry)values2[i]) != null; ++i) {
            ordered.add(value2);
        }
        map2.release();
        InternalFullHistogramFacet ret = new InternalFullHistogramFacet(this.getName());
        ret.comparatorType = this.comparatorType;
        ret.entries = ordered;
        return ret;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        builder.field(Fields._TYPE, "histogram");
        builder.startArray(Fields.ENTRIES);
        for (FullEntry entry2 : this.entries) {
            builder.startObject();
            builder.field(Fields.KEY, entry2.getKey());
            builder.field(Fields.COUNT, entry2.getCount());
            builder.field(Fields.MIN, entry2.getMin());
            builder.field(Fields.MAX, entry2.getMax());
            builder.field(Fields.TOTAL, entry2.getTotal());
            builder.field(Fields.TOTAL_COUNT, entry2.getTotalCount());
            builder.field(Fields.MEAN, entry2.getMean());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static InternalFullHistogramFacet readHistogramFacet(StreamInput in) throws IOException {
        InternalFullHistogramFacet facet = new InternalFullHistogramFacet();
        facet.readFrom(in);
        return facet;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.comparatorType = HistogramFacet.ComparatorType.fromId(in.readByte());
        int size2 = in.readVInt();
        this.entries = new ArrayList<FullEntry>(size2);
        for (int i = 0; i < size2; ++i) {
            this.entries.add(new FullEntry(in.readLong(), in.readVLong(), in.readDouble(), in.readDouble(), in.readVLong(), in.readDouble()));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeByte(this.comparatorType.id());
        out.writeVInt(this.entries.size());
        for (FullEntry entry2 : this.entries) {
            out.writeLong(entry2.key);
            out.writeVLong(entry2.count);
            out.writeDouble(entry2.min);
            out.writeDouble(entry2.max);
            out.writeVLong(entry2.totalCount);
            out.writeDouble(entry2.total);
        }
    }

    static final class Fields {
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString ENTRIES = new XContentBuilderString("entries");
        static final XContentBuilderString KEY = new XContentBuilderString("key");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString TOTAL_COUNT = new XContentBuilderString("total_count");
        static final XContentBuilderString MEAN = new XContentBuilderString("mean");
        static final XContentBuilderString MIN = new XContentBuilderString("min");
        static final XContentBuilderString MAX = new XContentBuilderString("max");

        Fields() {
        }
    }

    public static class FullEntry
    implements HistogramFacet.Entry {
        long key;
        long count;
        long totalCount;
        double total;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;

        public FullEntry(long key, long count2, double min2, double max2, long totalCount, double total) {
            this.key = key;
            this.count = count2;
            this.min = min2;
            this.max = max2;
            this.totalCount = totalCount;
            this.total = total;
        }

        @Override
        public long getKey() {
            return this.key;
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public double getTotal() {
            return this.total;
        }

        @Override
        public long getTotalCount() {
            return this.totalCount;
        }

        @Override
        public double getMean() {
            return this.total / (double)this.totalCount;
        }

        @Override
        public double getMin() {
            return this.min;
        }

        @Override
        public double getMax() {
            return this.max;
        }
    }
}

