/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.histogram;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.hppc.LongLongOpenHashMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.histogram.HistogramFacet;
import org.elasticsearch.search.facet.histogram.InternalHistogramFacet;

public class InternalCountHistogramFacet
extends InternalHistogramFacet {
    private static final BytesReference STREAM_TYPE = new HashedBytesArray(Strings.toUTF8Bytes("cHistogram"));
    static InternalFacet.Stream STREAM = new InternalFacet.Stream(){

        @Override
        public Facet readFacet(StreamInput in) throws IOException {
            return InternalCountHistogramFacet.readHistogramFacet(in);
        }
    };
    HistogramFacet.ComparatorType comparatorType;
    CountEntry[] entries = null;

    public static void registerStreams() {
        InternalFacet.Streams.registerStream(STREAM, STREAM_TYPE);
    }

    @Override
    public BytesReference streamType() {
        return STREAM_TYPE;
    }

    InternalCountHistogramFacet() {
    }

    public InternalCountHistogramFacet(String name, HistogramFacet.ComparatorType comparatorType, CountEntry[] entries) {
        super(name);
        this.comparatorType = comparatorType;
        this.entries = entries;
    }

    public List<CountEntry> getEntries() {
        return Arrays.asList(this.entries);
    }

    @Override
    public Iterator<HistogramFacet.Entry> iterator() {
        return this.getEntries().iterator();
    }

    @Override
    public Facet reduce(InternalFacet.ReduceContext context) {
        List<Facet> facets = context.facets();
        if (facets.size() == 1) {
            InternalCountHistogramFacet histoFacet = (InternalCountHistogramFacet)facets.get(0);
            Arrays.sort(histoFacet.entries, histoFacet.comparatorType.comparator());
            return facets.get(0);
        }
        Recycler.V<LongLongOpenHashMap> counts = context.cacheRecycler().longLongMap(-1);
        for (Facet facet : facets) {
            InternalCountHistogramFacet histoFacet = (InternalCountHistogramFacet)facet;
            for (CountEntry entry2 : histoFacet.entries) {
                counts.v().addTo(entry2.getKey(), entry2.getCount());
            }
        }
        boolean[] states = counts.v().allocated;
        long[] keys = counts.v().keys;
        long[] values2 = counts.v().values;
        CountEntry[] entries = new CountEntry[counts.v().size()];
        int entryIndex = 0;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            entries[entryIndex++] = new CountEntry(keys[i], values2[i]);
        }
        counts.release();
        Arrays.sort(entries, this.comparatorType.comparator());
        return new InternalCountHistogramFacet(this.getName(), this.comparatorType, entries);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        builder.field(Fields._TYPE, "histogram");
        builder.startArray(Fields.ENTRIES);
        for (CountEntry entry2 : this.entries) {
            builder.startObject();
            builder.field(Fields.KEY, entry2.getKey());
            builder.field(Fields.COUNT, entry2.getCount());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static InternalCountHistogramFacet readHistogramFacet(StreamInput in) throws IOException {
        InternalCountHistogramFacet facet = new InternalCountHistogramFacet();
        facet.readFrom(in);
        return facet;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.comparatorType = HistogramFacet.ComparatorType.fromId(in.readByte());
        int size2 = in.readVInt();
        this.entries = new CountEntry[size2];
        for (int i = 0; i < size2; ++i) {
            this.entries[i] = new CountEntry(in.readLong(), in.readVLong());
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeByte(this.comparatorType.id());
        out.writeVInt(this.entries.length);
        for (CountEntry entry2 : this.entries) {
            out.writeLong(entry2.getKey());
            out.writeVLong(entry2.getCount());
        }
    }

    static final class Fields {
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString ENTRIES = new XContentBuilderString("entries");
        static final XContentBuilderString KEY = new XContentBuilderString("key");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");

        Fields() {
        }
    }

    public static class CountEntry
    implements HistogramFacet.Entry {
        private final long key;
        private final long count;

        public CountEntry(long key, long count2) {
            this.key = key;
            this.count = count2;
        }

        @Override
        public long getKey() {
            return this.key;
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public double getTotal() {
            return Double.NaN;
        }

        @Override
        public long getTotalCount() {
            return 0L;
        }

        @Override
        public double getMean() {
            return Double.NaN;
        }

        @Override
        public double getMin() {
            return Double.NaN;
        }

        @Override
        public double getMax() {
            return Double.NaN;
        }
    }
}

