/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.histogram;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.FacetParser;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.histogram.CountHistogramFacetExecutor;
import org.elasticsearch.search.facet.histogram.FullHistogramFacetExecutor;
import org.elasticsearch.search.facet.histogram.HistogramFacet;
import org.elasticsearch.search.facet.histogram.InternalHistogramFacet;
import org.elasticsearch.search.facet.histogram.ScriptHistogramFacetExecutor;
import org.elasticsearch.search.facet.histogram.ValueHistogramFacetExecutor;
import org.elasticsearch.search.facet.histogram.ValueScriptHistogramFacetExecutor;
import org.elasticsearch.search.internal.SearchContext;

public class HistogramFacetParser
extends AbstractComponent
implements FacetParser {
    @Inject
    public HistogramFacetParser(Settings settings) {
        super(settings);
        InternalHistogramFacet.registerStreams();
    }

    @Override
    public String[] types() {
        return new String[]{"histogram"};
    }

    @Override
    public FacetExecutor.Mode defaultMainMode() {
        return FacetExecutor.Mode.COLLECTOR;
    }

    @Override
    public FacetExecutor.Mode defaultGlobalMode() {
        return FacetExecutor.Mode.COLLECTOR;
    }

    @Override
    public FacetExecutor parse(String facetName, XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token2;
        String keyField = null;
        String valueField = null;
        String keyScript = null;
        String valueScript = null;
        String scriptLang = null;
        Map<String, Object> params = null;
        long interval = 0L;
        HistogramFacet.ComparatorType comparatorType = HistogramFacet.ComparatorType.KEY;
        String fieldName = null;
        while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token2 == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                continue;
            }
            if (token2 == XContentParser.Token.START_OBJECT) {
                if (!"params".equals(fieldName)) continue;
                params = parser.map();
                continue;
            }
            if (!token2.isValue()) continue;
            if ("field".equals(fieldName)) {
                keyField = parser.text();
                continue;
            }
            if ("key_field".equals(fieldName) || "keyField".equals(fieldName)) {
                keyField = parser.text();
                continue;
            }
            if ("value_field".equals(fieldName) || "valueField".equals(fieldName)) {
                valueField = parser.text();
                continue;
            }
            if ("interval".equals(fieldName)) {
                interval = parser.longValue();
                continue;
            }
            if ("time_interval".equals(fieldName)) {
                interval = TimeValue.parseTimeValue(parser.text(), null).millis();
                continue;
            }
            if ("key_script".equals(fieldName) || "keyScript".equals(fieldName)) {
                keyScript = parser.text();
                continue;
            }
            if ("value_script".equals(fieldName) || "valueScript".equals(fieldName)) {
                valueScript = parser.text();
                continue;
            }
            if ("order".equals(fieldName) || "comparator".equals(fieldName)) {
                comparatorType = HistogramFacet.ComparatorType.fromString(parser.text());
                continue;
            }
            if (!"lang".equals(fieldName)) continue;
            scriptLang = parser.text();
        }
        if (keyScript != null && valueScript != null) {
            return new ScriptHistogramFacetExecutor(scriptLang, keyScript, valueScript, params, interval, comparatorType, context);
        }
        if (keyField == null) {
            throw new FacetPhaseExecutionException(facetName, "key field is required to be set for histogram facet, either using [field] or using [key_field]");
        }
        if (interval <= 0L) {
            throw new FacetPhaseExecutionException(facetName, "[interval] is required to be set for histogram facet");
        }
        FieldMapper keyMapper = context.smartNameFieldMapper(keyField);
        if (keyMapper == null) {
            throw new FacetPhaseExecutionException(facetName, "No mapping found for key_field [" + keyField + "]");
        }
        IndexNumericFieldData keyIndexFieldData = (IndexNumericFieldData)context.fieldData().getForField(keyMapper);
        IndexNumericFieldData valueIndexFieldData = null;
        if (valueField != null) {
            FieldMapper valueMapper = context.smartNameFieldMapper(valueField);
            if (valueMapper == null) {
                throw new FacetPhaseExecutionException(facetName, "No mapping found for value_field [" + valueField + "]");
            }
            valueIndexFieldData = (IndexNumericFieldData)context.fieldData().getForField(valueMapper);
        }
        if (valueScript != null) {
            return new ValueScriptHistogramFacetExecutor(keyIndexFieldData, scriptLang, valueScript, params, interval, comparatorType, context);
        }
        if (valueField == null) {
            return new CountHistogramFacetExecutor(keyIndexFieldData, interval, comparatorType, context);
        }
        if (keyField.equals(valueField)) {
            return new FullHistogramFacetExecutor(keyIndexFieldData, interval, comparatorType, context);
        }
        return new ValueHistogramFacetExecutor(keyIndexFieldData, valueIndexFieldData, interval, comparatorType, context);
    }
}

