/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.histogram;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.common.hppc.LongObjectOpenHashMap;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.search.facet.DoubleFacetAggregatorBase;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.histogram.HistogramFacet;
import org.elasticsearch.search.facet.histogram.InternalFullHistogramFacet;
import org.elasticsearch.search.internal.SearchContext;

public class FullHistogramFacetExecutor
extends FacetExecutor {
    private final IndexNumericFieldData indexFieldData;
    private final HistogramFacet.ComparatorType comparatorType;
    final long interval;
    final Recycler.V<LongObjectOpenHashMap<InternalFullHistogramFacet.FullEntry>> entries;

    public FullHistogramFacetExecutor(IndexNumericFieldData indexFieldData, long interval, HistogramFacet.ComparatorType comparatorType, SearchContext context) {
        this.comparatorType = comparatorType;
        this.indexFieldData = indexFieldData;
        this.interval = interval;
        this.entries = context.cacheRecycler().longObjectMap(-1);
    }

    @Override
    public Collector collector() {
        return new Collector();
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        ArrayList<InternalFullHistogramFacet.FullEntry> fullEntries = new ArrayList<InternalFullHistogramFacet.FullEntry>(this.entries.v().size());
        boolean[] states = this.entries.v().allocated;
        VType[] values2 = this.entries.v().values;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            fullEntries.add((InternalFullHistogramFacet.FullEntry)values2[i]);
        }
        this.entries.release();
        return new InternalFullHistogramFacet(facetName, this.comparatorType, fullEntries);
    }

    public static long bucket(double value2, long interval) {
        return (long)(value2 / (double)interval) * interval;
    }

    public static final class HistogramProc
    extends DoubleFacetAggregatorBase {
        final long interval;
        final LongObjectOpenHashMap<InternalFullHistogramFacet.FullEntry> entries;

        public HistogramProc(long interval, LongObjectOpenHashMap<InternalFullHistogramFacet.FullEntry> entries) {
            this.interval = interval;
            this.entries = entries;
        }

        @Override
        public void onValue(int docId, double value2) {
            long bucket = FullHistogramFacetExecutor.bucket(value2, this.interval);
            InternalFullHistogramFacet.FullEntry entry2 = this.entries.get(bucket);
            if (entry2 == null) {
                entry2 = new InternalFullHistogramFacet.FullEntry(bucket, 1L, value2, value2, 1L, value2);
                this.entries.put(bucket, entry2);
            } else {
                ++entry2.count;
                ++entry2.totalCount;
                entry2.total += value2;
                if (value2 < entry2.min) {
                    entry2.min = value2;
                }
                if (value2 > entry2.max) {
                    entry2.max = value2;
                }
            }
        }
    }

    class Collector
    extends FacetExecutor.Collector {
        private final HistogramProc histoProc;
        private DoubleValues values;

        Collector() {
            this.histoProc = new HistogramProc(FullHistogramFacetExecutor.this.interval, FullHistogramFacetExecutor.this.entries.v());
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.values = FullHistogramFacetExecutor.this.indexFieldData.load(context).getDoubleValues();
        }

        @Override
        public void collect(int doc) throws IOException {
            this.histoProc.onDoc(doc, this.values);
        }

        @Override
        public void postCollection() {
        }
    }
}

