/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.histogram;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.common.hppc.LongLongOpenHashMap;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.search.facet.DoubleFacetAggregatorBase;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.histogram.HistogramFacet;
import org.elasticsearch.search.facet.histogram.InternalCountHistogramFacet;
import org.elasticsearch.search.internal.SearchContext;

public class CountHistogramFacetExecutor
extends FacetExecutor {
    private final IndexNumericFieldData indexFieldData;
    private final HistogramFacet.ComparatorType comparatorType;
    final long interval;
    final Recycler.V<LongLongOpenHashMap> counts;

    public CountHistogramFacetExecutor(IndexNumericFieldData indexFieldData, long interval, HistogramFacet.ComparatorType comparatorType, SearchContext context) {
        this.comparatorType = comparatorType;
        this.indexFieldData = indexFieldData;
        this.interval = interval;
        this.counts = context.cacheRecycler().longLongMap(-1);
    }

    @Override
    public Collector collector() {
        return new Collector();
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        InternalCountHistogramFacet.CountEntry[] entries = new InternalCountHistogramFacet.CountEntry[this.counts.v().size()];
        boolean[] states = this.counts.v().allocated;
        long[] keys = this.counts.v().keys;
        long[] values2 = this.counts.v().values;
        int entryIndex = 0;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            entries[entryIndex++] = new InternalCountHistogramFacet.CountEntry(keys[i], values2[i]);
        }
        this.counts.release();
        return new InternalCountHistogramFacet(facetName, this.comparatorType, entries);
    }

    public static long bucket(double value2, long interval) {
        return (long)(value2 / (double)interval) * interval;
    }

    public static final class HistogramProc
    extends DoubleFacetAggregatorBase {
        private final long interval;
        private final LongLongOpenHashMap counts;

        public HistogramProc(long interval, LongLongOpenHashMap counts) {
            this.interval = interval;
            this.counts = counts;
        }

        @Override
        public void onValue(int docId, double value2) {
            long bucket = CountHistogramFacetExecutor.bucket(value2, this.interval);
            this.counts.addTo(bucket, 1L);
        }

        public LongLongOpenHashMap counts() {
            return this.counts;
        }
    }

    class Collector
    extends FacetExecutor.Collector {
        private final HistogramProc histoProc;
        private DoubleValues values;

        public Collector() {
            this.histoProc = new HistogramProc(CountHistogramFacetExecutor.this.interval, CountHistogramFacetExecutor.this.counts.v());
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.values = CountHistogramFacetExecutor.this.indexFieldData.load(context).getDoubleValues();
        }

        @Override
        public void collect(int doc) throws IOException {
            this.histoProc.onDoc(doc, this.values);
        }

        @Override
        public void postCollection() {
        }
    }
}

