/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.geodistance;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.geodistance.GeoDistanceFacet;

public class InternalGeoDistanceFacet
extends InternalFacet
implements GeoDistanceFacet {
    private static final BytesReference STREAM_TYPE = new HashedBytesArray(Strings.toUTF8Bytes("geoDistance"));
    static InternalFacet.Stream STREAM = new InternalFacet.Stream(){

        @Override
        public Facet readFacet(StreamInput in) throws IOException {
            return InternalGeoDistanceFacet.readGeoDistanceFacet(in);
        }
    };
    GeoDistanceFacet.Entry[] entries;

    public static void registerStreams() {
        InternalFacet.Streams.registerStream(STREAM, STREAM_TYPE);
    }

    @Override
    public BytesReference streamType() {
        return STREAM_TYPE;
    }

    InternalGeoDistanceFacet() {
    }

    public InternalGeoDistanceFacet(String name, GeoDistanceFacet.Entry[] entries) {
        super(name);
        this.entries = entries;
    }

    @Override
    public String getType() {
        return "geo_distance";
    }

    @Override
    public List<GeoDistanceFacet.Entry> getEntries() {
        return ImmutableList.copyOf(this.entries);
    }

    @Override
    public Iterator<GeoDistanceFacet.Entry> iterator() {
        return this.getEntries().iterator();
    }

    @Override
    public Facet reduce(InternalFacet.ReduceContext context) {
        List<Facet> facets = context.facets();
        if (facets.size() == 1) {
            return facets.get(0);
        }
        InternalGeoDistanceFacet agg = (InternalGeoDistanceFacet)facets.get(0);
        for (int i = 1; i < facets.size(); ++i) {
            InternalGeoDistanceFacet geoDistanceFacet = (InternalGeoDistanceFacet)facets.get(i);
            for (int j = 0; j < geoDistanceFacet.entries.length; ++j) {
                GeoDistanceFacet.Entry aggEntry = agg.entries[j];
                GeoDistanceFacet.Entry currentEntry = geoDistanceFacet.entries[j];
                aggEntry.count += currentEntry.count;
                aggEntry.totalCount += currentEntry.totalCount;
                aggEntry.total += currentEntry.total;
                if (currentEntry.min < aggEntry.min) {
                    aggEntry.min = currentEntry.min;
                }
                if (!(currentEntry.max > aggEntry.max)) continue;
                aggEntry.max = currentEntry.max;
            }
        }
        return agg;
    }

    public static InternalGeoDistanceFacet readGeoDistanceFacet(StreamInput in) throws IOException {
        InternalGeoDistanceFacet facet = new InternalGeoDistanceFacet();
        facet.readFrom(in);
        return facet;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.entries = new GeoDistanceFacet.Entry[in.readVInt()];
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i] = new GeoDistanceFacet.Entry(in.readDouble(), in.readDouble(), in.readVLong(), in.readVLong(), in.readDouble(), in.readDouble(), in.readDouble());
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.entries.length);
        for (GeoDistanceFacet.Entry entry2 : this.entries) {
            out.writeDouble(entry2.from);
            out.writeDouble(entry2.to);
            out.writeVLong(entry2.count);
            out.writeVLong(entry2.totalCount);
            out.writeDouble(entry2.total);
            out.writeDouble(entry2.min);
            out.writeDouble(entry2.max);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        builder.field(Fields._TYPE, "geo_distance");
        builder.startArray(Fields.RANGES);
        for (GeoDistanceFacet.Entry entry2 : this.entries) {
            builder.startObject();
            if (!Double.isInfinite(entry2.from)) {
                builder.field(Fields.FROM, entry2.from);
            }
            if (!Double.isInfinite(entry2.to)) {
                builder.field(Fields.TO, entry2.to);
            }
            builder.field(Fields.COUNT, entry2.getCount());
            builder.field(Fields.MIN, entry2.getMin());
            builder.field(Fields.MAX, entry2.getMax());
            builder.field(Fields.TOTAL_COUNT, entry2.getTotalCount());
            builder.field(Fields.TOTAL, entry2.getTotal());
            builder.field(Fields.MEAN, entry2.getMean());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString RANGES = new XContentBuilderString("ranges");
        static final XContentBuilderString FROM = new XContentBuilderString("from");
        static final XContentBuilderString TO = new XContentBuilderString("to");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");
        static final XContentBuilderString TOTAL_COUNT = new XContentBuilderString("total_count");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString MEAN = new XContentBuilderString("mean");
        static final XContentBuilderString MIN = new XContentBuilderString("min");
        static final XContentBuilderString MAX = new XContentBuilderString("max");

        Fields() {
        }
    }
}

