/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.geodistance;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.geodistance.GeoDistanceFacet;
import org.elasticsearch.search.facet.geodistance.InternalGeoDistanceFacet;
import org.elasticsearch.search.internal.SearchContext;

public class GeoDistanceFacetExecutor
extends FacetExecutor {
    final IndexGeoPointFieldData indexFieldData;
    final double lat;
    final double lon;
    final DistanceUnit unit;
    final GeoDistance geoDistance;
    final GeoDistance.FixedSourceDistance fixedSourceDistance;
    final GeoDistanceFacet.Entry[] entries;

    public GeoDistanceFacetExecutor(IndexGeoPointFieldData indexFieldData, double lat, double lon, DistanceUnit unit, GeoDistance geoDistance, GeoDistanceFacet.Entry[] entries, SearchContext context) {
        this.lat = lat;
        this.lon = lon;
        this.unit = unit;
        this.entries = entries;
        this.geoDistance = geoDistance;
        this.indexFieldData = indexFieldData;
        this.fixedSourceDistance = geoDistance.fixedSourceDistance(lat, lon, unit);
    }

    @Override
    public Collector collector() {
        return new Collector(new Aggregator(this.fixedSourceDistance, this.entries));
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        return new InternalGeoDistanceFacet(facetName, this.entries);
    }

    public static class Aggregator {
        protected final GeoDistance.FixedSourceDistance fixedSourceDistance;
        protected final GeoDistanceFacet.Entry[] entries;

        public Aggregator(GeoDistance.FixedSourceDistance fixedSourceDistance, GeoDistanceFacet.Entry[] entries) {
            this.fixedSourceDistance = fixedSourceDistance;
            this.entries = entries;
        }

        public void onDoc(int docId, GeoPointValues values2) {
            int length = values2.setDocument(docId);
            for (int i = 0; i < length; ++i) {
                GeoPoint next2 = values2.nextValue();
                double distance = this.fixedSourceDistance.calculate(next2.getLat(), next2.getLon());
                for (GeoDistanceFacet.Entry entry2 : this.entries) {
                    if (entry2.foundInDoc || !(distance >= entry2.getFrom()) || !(distance < entry2.getTo())) continue;
                    entry2.foundInDoc = true;
                    this.collectGeoPoint(entry2, docId, distance);
                }
            }
        }

        protected void collectGeoPoint(GeoDistanceFacet.Entry entry2, int docId, double distance) {
            ++entry2.count;
            ++entry2.totalCount;
            entry2.total += distance;
            if (distance < entry2.min) {
                entry2.min = distance;
            }
            if (distance > entry2.max) {
                entry2.max = distance;
            }
        }
    }

    class Collector
    extends FacetExecutor.Collector {
        protected GeoPointValues values;
        protected final Aggregator aggregator;

        Collector(Aggregator aggregator) {
            this.aggregator = aggregator;
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.values = ((AtomicGeoPointFieldData)GeoDistanceFacetExecutor.this.indexFieldData.load(context)).getGeoPointValues();
        }

        @Override
        public void collect(int doc) throws IOException {
            for (GeoDistanceFacet.Entry entry2 : GeoDistanceFacetExecutor.this.entries) {
                entry2.foundInDoc = false;
            }
            this.aggregator.onDoc(doc, this.values);
        }

        @Override
        public void postCollection() {
        }
    }
}

