/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.geodistance;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilderException;
import org.elasticsearch.search.facet.FacetBuilder;

public class GeoDistanceFacetBuilder
extends FacetBuilder {
    private String fieldName;
    private String valueFieldName;
    private double lat;
    private double lon;
    private String geohash;
    private GeoDistance geoDistance;
    private DistanceUnit unit;
    private Map<String, Object> params;
    private String valueScript;
    private String lang;
    private List<Entry> entries = Lists.newArrayList();

    public GeoDistanceFacetBuilder(String name) {
        super(name);
    }

    public GeoDistanceFacetBuilder field(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public GeoDistanceFacetBuilder valueField(String valueFieldName) {
        this.valueFieldName = valueFieldName;
        return this;
    }

    public GeoDistanceFacetBuilder valueScript(String valueScript) {
        this.valueScript = valueScript;
        return this;
    }

    public GeoDistanceFacetBuilder lang(String lang) {
        this.lang = lang;
        return this;
    }

    public GeoDistanceFacetBuilder scriptParam(String name, Object value2) {
        if (this.params == null) {
            this.params = Maps.newHashMap();
        }
        this.params.put(name, value2);
        return this;
    }

    public GeoDistanceFacetBuilder point(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
        return this;
    }

    public GeoDistanceFacetBuilder lat(double lat) {
        this.lat = lat;
        return this;
    }

    public GeoDistanceFacetBuilder lon(double lon) {
        this.lon = lon;
        return this;
    }

    public GeoDistanceFacetBuilder geohash(String geohash) {
        this.geohash = geohash;
        return this;
    }

    public GeoDistanceFacetBuilder geoDistance(GeoDistance geoDistance) {
        this.geoDistance = geoDistance;
        return this;
    }

    public GeoDistanceFacetBuilder addRange(double from2, double to2) {
        this.entries.add(new Entry(from2, to2));
        return this;
    }

    public GeoDistanceFacetBuilder addUnboundedTo(double from2) {
        this.entries.add(new Entry(from2, Double.POSITIVE_INFINITY));
        return this;
    }

    public GeoDistanceFacetBuilder addUnboundedFrom(double to2) {
        this.entries.add(new Entry(Double.NEGATIVE_INFINITY, to2));
        return this;
    }

    public GeoDistanceFacetBuilder unit(DistanceUnit unit) {
        this.unit = unit;
        return this;
    }

    @Override
    public GeoDistanceFacetBuilder global(boolean global) {
        super.global(global);
        return this;
    }

    @Override
    public GeoDistanceFacetBuilder facetFilter(FilterBuilder filter2) {
        this.facetFilter = filter2;
        return this;
    }

    @Override
    public GeoDistanceFacetBuilder nested(String nested) {
        this.nested = nested;
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.fieldName == null) {
            throw new SearchSourceBuilderException("field must be set on geo_distance facet for facet [" + this.name + "]");
        }
        if (this.entries.isEmpty()) {
            throw new SearchSourceBuilderException("at least one range must be defined for geo_distance facet [" + this.name + "]");
        }
        builder.startObject(this.name);
        builder.startObject("geo_distance");
        if (this.geohash != null) {
            builder.field(this.fieldName, this.geohash);
        } else {
            builder.startArray(this.fieldName).value(this.lon).value(this.lat).endArray();
        }
        if (this.valueFieldName != null) {
            builder.field("value_field", this.valueFieldName);
        }
        if (this.valueScript != null) {
            builder.field("value_script", this.valueScript);
            if (this.lang != null) {
                builder.field("lang", this.lang);
            }
            if (this.params != null) {
                builder.field("params", this.params);
            }
        }
        builder.startArray("ranges");
        for (Entry entry2 : this.entries) {
            builder.startObject();
            if (!Double.isInfinite(entry2.from)) {
                builder.field("from", entry2.from);
            }
            if (!Double.isInfinite(entry2.to)) {
                builder.field("to", entry2.to);
            }
            builder.endObject();
        }
        builder.endArray();
        if (this.unit != null) {
            builder.field("unit", (Object)this.unit);
        }
        if (this.geoDistance != null) {
            builder.field("distance_type", this.geoDistance.name().toLowerCase(Locale.ROOT));
        }
        builder.endObject();
        this.addFilterFacetAndGlobal(builder, params);
        builder.endObject();
        return builder;
    }

    private static class Entry {
        final double from;
        final double to;

        private Entry(double from2, double to2) {
            this.from = from2;
            this.to = to2;
        }
    }
}

