/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.geodistance;

import java.util.List;
import org.elasticsearch.search.facet.Facet;

public interface GeoDistanceFacet
extends Facet,
Iterable<Entry> {
    public static final String TYPE = "geo_distance";

    public List<Entry> getEntries();

    public static class Entry {
        double from = Double.NEGATIVE_INFINITY;
        double to = Double.POSITIVE_INFINITY;
        long count;
        long totalCount;
        double total;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        boolean foundInDoc = false;

        Entry() {
        }

        public Entry(double from2, double to2, long count2, long totalCount, double total, double min2, double max2) {
            this.from = from2;
            this.to = to2;
            this.count = count2;
            this.totalCount = totalCount;
            this.total = total;
            this.min = min2;
            this.max = max2;
        }

        public double getFrom() {
            return this.from;
        }

        public double getTo() {
            return this.to;
        }

        public long getCount() {
            return this.count;
        }

        public long getTotalCount() {
            return this.totalCount;
        }

        public double getTotal() {
            return this.total;
        }

        public double getMean() {
            if (this.totalCount == 0L) {
                return 0.0;
            }
            return this.total / (double)this.totalCount;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }
    }
}

