/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.datehistogram;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.cache.recycler.CacheRecycler;
import org.elasticsearch.common.hppc.LongObjectOpenHashMap;
import org.elasticsearch.common.joda.TimeZoneRounding;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.LongValues;
import org.elasticsearch.search.facet.DoubleFacetAggregatorBase;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.LongFacetAggregatorBase;
import org.elasticsearch.search.facet.datehistogram.DateHistogramFacet;
import org.elasticsearch.search.facet.datehistogram.InternalFullDateHistogramFacet;

public class ValueDateHistogramFacetExecutor
extends FacetExecutor {
    private final IndexNumericFieldData keyIndexFieldData;
    private final IndexNumericFieldData valueIndexFieldData;
    private final DateHistogramFacet.ComparatorType comparatorType;
    final TimeZoneRounding tzRounding;
    final Recycler.V<LongObjectOpenHashMap<InternalFullDateHistogramFacet.FullEntry>> entries;

    public ValueDateHistogramFacetExecutor(IndexNumericFieldData keyIndexFieldData, IndexNumericFieldData valueIndexFieldData, TimeZoneRounding tzRounding, DateHistogramFacet.ComparatorType comparatorType, CacheRecycler cacheRecycler) {
        this.comparatorType = comparatorType;
        this.keyIndexFieldData = keyIndexFieldData;
        this.valueIndexFieldData = valueIndexFieldData;
        this.tzRounding = tzRounding;
        this.entries = cacheRecycler.longObjectMap(-1);
    }

    @Override
    public Collector collector() {
        return new Collector();
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        ArrayList<InternalFullDateHistogramFacet.FullEntry> entries1 = new ArrayList<InternalFullDateHistogramFacet.FullEntry>(this.entries.v().size());
        boolean[] states = this.entries.v().allocated;
        VType[] values2 = this.entries.v().values;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            InternalFullDateHistogramFacet.FullEntry value2 = (InternalFullDateHistogramFacet.FullEntry)values2[i];
            entries1.add(value2);
        }
        this.entries.release();
        return new InternalFullDateHistogramFacet(facetName, this.comparatorType, entries1);
    }

    public static class DateHistogramProc
    extends LongFacetAggregatorBase {
        final LongObjectOpenHashMap<InternalFullDateHistogramFacet.FullEntry> entries;
        private final TimeZoneRounding tzRounding;
        DoubleValues valueValues;
        final ValueAggregator valueAggregator = new ValueAggregator();

        public DateHistogramProc(TimeZoneRounding tzRounding, LongObjectOpenHashMap<InternalFullDateHistogramFacet.FullEntry> entries) {
            this.tzRounding = tzRounding;
            this.entries = entries;
        }

        @Override
        public void onValue(int docId, long value2) {
            long time = this.tzRounding.calc(value2);
            InternalFullDateHistogramFacet.FullEntry entry2 = this.entries.get(time);
            if (entry2 == null) {
                entry2 = new InternalFullDateHistogramFacet.FullEntry(time, 0L, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 0L, 0.0);
                this.entries.put(time, entry2);
            }
            ++entry2.count;
            this.valueAggregator.entry = entry2;
            this.valueAggregator.onDoc(docId, this.valueValues);
        }

        public static final class ValueAggregator
        extends DoubleFacetAggregatorBase {
            InternalFullDateHistogramFacet.FullEntry entry;

            @Override
            public void onValue(int docId, double value2) {
                ++this.entry.totalCount;
                this.entry.total += value2;
                if (value2 < this.entry.min) {
                    this.entry.min = value2;
                }
                if (value2 > this.entry.max) {
                    this.entry.max = value2;
                }
            }
        }
    }

    class Collector
    extends FacetExecutor.Collector {
        private final DateHistogramProc histoProc;
        private LongValues keyValues;

        public Collector() {
            this.histoProc = new DateHistogramProc(ValueDateHistogramFacetExecutor.this.tzRounding, ValueDateHistogramFacetExecutor.this.entries.v());
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.keyValues = ValueDateHistogramFacetExecutor.this.keyIndexFieldData.load(context).getLongValues();
            this.histoProc.valueValues = ValueDateHistogramFacetExecutor.this.valueIndexFieldData.load(context).getDoubleValues();
        }

        @Override
        public void collect(int doc) throws IOException {
            this.histoProc.onDoc(doc, this.keyValues);
        }

        @Override
        public void postCollection() {
        }
    }
}

