/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.datehistogram;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.hppc.LongLongOpenHashMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.datehistogram.DateHistogramFacet;
import org.elasticsearch.search.facet.datehistogram.InternalDateHistogramFacet;

public class InternalCountDateHistogramFacet
extends InternalDateHistogramFacet {
    private static final BytesReference STREAM_TYPE = new HashedBytesArray(Strings.toUTF8Bytes("cdHistogram"));
    static InternalFacet.Stream STREAM = new InternalFacet.Stream(){

        @Override
        public Facet readFacet(StreamInput in) throws IOException {
            return InternalCountDateHistogramFacet.readHistogramFacet(in);
        }
    };
    DateHistogramFacet.ComparatorType comparatorType;
    CountEntry[] entries = null;

    public static void registerStreams() {
        InternalFacet.Streams.registerStream(STREAM, STREAM_TYPE);
    }

    @Override
    public BytesReference streamType() {
        return STREAM_TYPE;
    }

    InternalCountDateHistogramFacet() {
    }

    public InternalCountDateHistogramFacet(String name, DateHistogramFacet.ComparatorType comparatorType, CountEntry[] entries) {
        super(name);
        this.comparatorType = comparatorType;
        this.entries = entries;
    }

    public List<CountEntry> getEntries() {
        return Arrays.asList(this.entries);
    }

    @Override
    public Iterator<DateHistogramFacet.Entry> iterator() {
        return this.getEntries().iterator();
    }

    @Override
    public Facet reduce(InternalFacet.ReduceContext context) {
        List<Facet> facets = context.facets();
        if (facets.size() == 1) {
            InternalCountDateHistogramFacet histoFacet = (InternalCountDateHistogramFacet)facets.get(0);
            Arrays.sort(histoFacet.entries, histoFacet.comparatorType.comparator());
            return facets.get(0);
        }
        Recycler.V<LongLongOpenHashMap> counts = context.cacheRecycler().longLongMap(-1);
        for (Facet facet : facets) {
            InternalCountDateHistogramFacet histoFacet = (InternalCountDateHistogramFacet)facet;
            for (CountEntry entry2 : histoFacet.entries) {
                counts.v().addTo(entry2.getTime(), entry2.getCount());
            }
        }
        CountEntry[] countEntries = new CountEntry[counts.v().size()];
        boolean[] states = counts.v().allocated;
        long[] keys = counts.v().keys;
        long[] values2 = counts.v().values;
        int entriesIndex = 0;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            countEntries[entriesIndex++] = new CountEntry(keys[i], values2[i]);
        }
        counts.release();
        Arrays.sort(countEntries, this.comparatorType.comparator());
        return new InternalCountDateHistogramFacet(this.getName(), this.comparatorType, countEntries);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        builder.field(Fields._TYPE, "date_histogram");
        builder.startArray(Fields.ENTRIES);
        for (CountEntry entry2 : this.entries) {
            builder.startObject();
            builder.field(Fields.TIME, entry2.getTime());
            builder.field(Fields.COUNT, entry2.getCount());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static InternalCountDateHistogramFacet readHistogramFacet(StreamInput in) throws IOException {
        InternalCountDateHistogramFacet facet = new InternalCountDateHistogramFacet();
        facet.readFrom(in);
        return facet;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.comparatorType = DateHistogramFacet.ComparatorType.fromId(in.readByte());
        int size2 = in.readVInt();
        this.entries = new CountEntry[size2];
        for (int i = 0; i < size2; ++i) {
            this.entries[i] = new CountEntry(in.readLong(), in.readVLong());
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeByte(this.comparatorType.id());
        out.writeVInt(this.entries.length);
        for (CountEntry entry2 : this.entries) {
            out.writeLong(entry2.getTime());
            out.writeVLong(entry2.getCount());
        }
    }

    static final class Fields {
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString ENTRIES = new XContentBuilderString("entries");
        static final XContentBuilderString TIME = new XContentBuilderString("time");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");

        Fields() {
        }
    }

    public static class CountEntry
    implements DateHistogramFacet.Entry {
        private final long time;
        private final long count;

        public CountEntry(long time, long count2) {
            this.time = time;
            this.count = count2;
        }

        @Override
        public long getTime() {
            return this.time;
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public long getTotalCount() {
            return 0L;
        }

        @Override
        public double getTotal() {
            return Double.NaN;
        }

        @Override
        public double getMean() {
            return Double.NaN;
        }

        @Override
        public double getMin() {
            return Double.NaN;
        }

        @Override
        public double getMax() {
            return Double.NaN;
        }
    }
}

