/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.BitsFilteredDocIdSet;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Query;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.docset.AllDocIdSet;
import org.elasticsearch.common.lucene.docset.ContextDocIdSet;
import org.elasticsearch.common.lucene.search.FilteredCollector;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.lucene.search.XCollector;
import org.elasticsearch.common.lucene.search.XConstantScoreQuery;
import org.elasticsearch.common.lucene.search.XFilteredQuery;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.SearchPhase;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetBinaryParseElement;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.FacetParseElement;
import org.elasticsearch.search.facet.InternalFacets;
import org.elasticsearch.search.facet.SearchContextFacets;
import org.elasticsearch.search.facet.nested.NestedFacetExecutor;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.query.QueryPhaseExecutionException;

public class FacetPhase
implements SearchPhase {
    private final FacetParseElement facetParseElement;
    private final FacetBinaryParseElement facetBinaryParseElement;

    @Inject
    public FacetPhase(FacetParseElement facetParseElement, FacetBinaryParseElement facetBinaryParseElement) {
        this.facetParseElement = facetParseElement;
        this.facetBinaryParseElement = facetBinaryParseElement;
    }

    @Override
    public Map<String, ? extends SearchParseElement> parseElements() {
        return ImmutableMap.of("facets", this.facetParseElement, "facets_binary", this.facetBinaryParseElement, "facetsBinary", this.facetBinaryParseElement);
    }

    @Override
    public void preProcess(SearchContext context) {
        if (context.facets() != null && context.facets().hasQuery()) {
            for (SearchContextFacets.Entry entry2 : context.facets().entries()) {
                if (entry2.isGlobal()) continue;
                if (entry2.getMode() == FacetExecutor.Mode.COLLECTOR) {
                    XCollector collector = entry2.getFacetExecutor().collector();
                    if (entry2.getFilter() != null) {
                        collector = collector instanceof NestedFacetExecutor.Collector ? new NestedFacetExecutor.Collector((NestedFacetExecutor.Collector)collector, entry2.getFilter()) : new FilteredCollector(collector, entry2.getFilter());
                    }
                    context.searcher().addMainQueryCollector(collector);
                    continue;
                }
                if (entry2.getMode() == FacetExecutor.Mode.POST) {
                    context.searcher().enableMainDocIdSetCollector();
                    continue;
                }
                throw new ElasticSearchIllegalStateException("what mode?");
            }
        }
    }

    @Override
    public void execute(SearchContext context) throws ElasticSearchException {
        if (context.facets() == null) {
            return;
        }
        if (context.queryResult().facets() != null) {
            return;
        }
        HashMap filtersByCollector = null;
        ArrayList<ContextDocIdSet> globalDocSets = null;
        for (SearchContextFacets.Entry entry2 : context.facets().entries()) {
            ArrayList<FacetExecutor.Collector> list2;
            FacetExecutor.Post post;
            if (!entry2.isGlobal()) {
                if (entry2.getMode() != FacetExecutor.Mode.POST) continue;
                post = entry2.getFacetExecutor().post();
                if (entry2.getFilter() != null) {
                    post = post instanceof NestedFacetExecutor.Post ? new NestedFacetExecutor.Post((NestedFacetExecutor.Post)post, entry2.getFilter()) : new FacetExecutor.Post.Filtered(post, entry2.getFilter());
                }
                try {
                    post.executePost(context.searcher().mainDocIdSetCollector().docSets());
                    continue;
                }
                catch (Exception e) {
                    throw new QueryPhaseExecutionException(context, "failed to execute facet [" + entry2.getFacetName() + "]", (Throwable)e);
                }
            }
            if (entry2.getMode() == FacetExecutor.Mode.POST) {
                if (globalDocSets == null) {
                    List<AtomicReaderContext> leaves = context.searcher().getIndexReader().leaves();
                    globalDocSets = new ArrayList<ContextDocIdSet>(leaves.size());
                    for (AtomicReaderContext leaf : leaves) {
                        globalDocSets.add(new ContextDocIdSet(leaf, BitsFilteredDocIdSet.wrap(new AllDocIdSet(leaf.reader().maxDoc()), leaf.reader().getLiveDocs())));
                    }
                }
                try {
                    post = entry2.getFacetExecutor().post();
                    if (entry2.getFilter() != null) {
                        post = post instanceof NestedFacetExecutor.Post ? new NestedFacetExecutor.Post((NestedFacetExecutor.Post)post, entry2.getFilter()) : new FacetExecutor.Post.Filtered(post, entry2.getFilter());
                    }
                    post.executePost(globalDocSets);
                    continue;
                }
                catch (Exception e) {
                    throw new QueryPhaseExecutionException(context, "Failed to execute facet [" + entry2.getFacetName() + "]", (Throwable)e);
                }
            }
            if (entry2.getMode() != FacetExecutor.Mode.COLLECTOR) continue;
            Filter filter2 = Queries.MATCH_ALL_FILTER;
            XCollector collector = entry2.getFacetExecutor().collector();
            if (entry2.getFilter() != null) {
                collector = collector instanceof NestedFacetExecutor.Collector ? new NestedFacetExecutor.Collector((NestedFacetExecutor.Collector)collector, entry2.getFilter()) : new FilteredCollector(collector, entry2.getFilter());
            }
            if (filtersByCollector == null) {
                filtersByCollector = Maps.newHashMap();
            }
            if ((list2 = (ArrayList<FacetExecutor.Collector>)filtersByCollector.get(filter2)) == null) {
                list2 = new ArrayList<FacetExecutor.Collector>();
                filtersByCollector.put(filter2, list2);
            }
            list2.add((FacetExecutor.Collector)collector);
        }
        if (filtersByCollector != null) {
            for (Map.Entry entry3 : filtersByCollector.entrySet()) {
                Filter filter2 = (Filter)entry3.getKey();
                Query query = new XConstantScoreQuery(filter2);
                Filter searchFilter = context.searchFilter(context.types());
                if (searchFilter != null) {
                    query = new XFilteredQuery(query, searchFilter);
                }
                try {
                    context.searcher().search(query, MultiCollector.wrap(((List)entry3.getValue()).toArray(new Collector[((List)entry3.getValue()).size()])));
                }
                catch (Exception e) {
                    throw new QueryPhaseExecutionException(context, "Failed to execute global facets", (Throwable)e);
                }
                for (Collector collector : (List)entry3.getValue()) {
                    if (!(collector instanceof XCollector)) continue;
                    ((XCollector)collector).postCollection();
                }
            }
        }
        ArrayList<Facet> facets = new ArrayList<Facet>(context.facets().entries().size());
        for (SearchContextFacets.Entry entry3 : context.facets().entries()) {
            facets.add(entry3.getFacetExecutor().buildFacet(entry3.getFacetName()));
        }
        context.queryResult().facets(new InternalFacets(facets));
    }
}

