/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet;

import java.util.Set;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.search.facet.FacetParser;

public class FacetParsers {
    private final ImmutableMap<String, FacetParser> processors;

    @Inject
    public FacetParsers(Set<FacetParser> processors) {
        MapBuilder<String, FacetParser> builder = MapBuilder.newMapBuilder();
        for (FacetParser processor : processors) {
            for (String type : processor.types()) {
                builder.put(type, processor);
            }
        }
        this.processors = builder.immutableMap();
    }

    public FacetParser processor(String type) {
        return this.processors.get(type);
    }
}

