/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.common.lucene.docset.AndDocIdSet;
import org.elasticsearch.common.lucene.docset.ContextDocIdSet;
import org.elasticsearch.common.lucene.search.XCollector;
import org.elasticsearch.search.facet.InternalFacet;

public abstract class FacetExecutor {
    public abstract InternalFacet buildFacet(String var1);

    public abstract Collector collector();

    public Post post() {
        return new Post.Collector(this.collector());
    }

    public static enum Mode {
        COLLECTOR,
        POST;

    }

    public static abstract class Collector
    extends XCollector {
        @Override
        public void setScorer(Scorer scorer) throws IOException {
        }

        @Override
        public boolean acceptsDocsOutOfOrder() {
            return true;
        }

        @Override
        public abstract void postCollection();
    }

    public static abstract class Post {
        public abstract void executePost(List<ContextDocIdSet> var1) throws IOException;

        public static class Collector
        extends Post {
            private final org.elasticsearch.search.facet.FacetExecutor$Collector collector;

            public Collector(org.elasticsearch.search.facet.FacetExecutor$Collector collector) {
                this.collector = collector;
            }

            @Override
            public void executePost(List<ContextDocIdSet> docSets) throws IOException {
                for (int i = 0; i < docSets.size(); ++i) {
                    int doc;
                    ContextDocIdSet docSet = docSets.get(i);
                    this.collector.setNextReader(docSet.context);
                    DocIdSetIterator it = docSet.docSet.iterator();
                    while ((doc = it.nextDoc()) != Integer.MAX_VALUE) {
                        this.collector.collect(doc);
                    }
                }
                this.collector.postCollection();
            }
        }

        public static class Filtered
        extends Post {
            private final Post post;
            private final Filter filter;

            public Filtered(Post post, Filter filter2) {
                this.post = post;
                this.filter = filter2;
            }

            @Override
            public void executePost(List<ContextDocIdSet> docSets) throws IOException {
                ArrayList<ContextDocIdSet> filteredEntries = new ArrayList<ContextDocIdSet>(docSets.size());
                for (int i = 0; i < docSets.size(); ++i) {
                    ContextDocIdSet entry2 = docSets.get(i);
                    DocIdSet filteredSet = this.filter.getDocIdSet(entry2.context, null);
                    if (filteredSet == null) continue;
                    filteredEntries.add(new ContextDocIdSet(entry2.context, new AndDocIdSet(new DocIdSet[]{entry2.docSet, filteredSet})));
                }
                this.post.executePost(filteredEntries);
            }
        }
    }
}

