/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.dfs;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.collect.HppcMaps;
import org.elasticsearch.common.hppc.ObjectObjectOpenHashMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.transport.TransportResponse;

public class DfsSearchResult
extends TransportResponse
implements SearchPhaseResult {
    private static final Term[] EMPTY_TERMS = new Term[0];
    private static final TermStatistics[] EMPTY_TERM_STATS = new TermStatistics[0];
    private SearchShardTarget shardTarget;
    private long id;
    private Term[] terms;
    private TermStatistics[] termStatistics;
    private ObjectObjectOpenHashMap<String, CollectionStatistics> fieldStatistics = HppcMaps.newNoNullKeysMap();
    private int maxDoc;

    public DfsSearchResult() {
    }

    public DfsSearchResult(long id, SearchShardTarget shardTarget) {
        this.id = id;
        this.shardTarget = shardTarget;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public SearchShardTarget shardTarget() {
        return this.shardTarget;
    }

    @Override
    public void shardTarget(SearchShardTarget shardTarget) {
        this.shardTarget = shardTarget;
    }

    public DfsSearchResult maxDoc(int maxDoc) {
        this.maxDoc = maxDoc;
        return this;
    }

    public int maxDoc() {
        return this.maxDoc;
    }

    public DfsSearchResult termsStatistics(Term[] terms, TermStatistics[] termStatistics) {
        this.terms = terms;
        this.termStatistics = termStatistics;
        return this;
    }

    public DfsSearchResult fieldStatistics(ObjectObjectOpenHashMap<String, CollectionStatistics> fieldStatistics) {
        this.fieldStatistics = fieldStatistics;
        return this;
    }

    public Term[] terms() {
        return this.terms;
    }

    public TermStatistics[] termStatistics() {
        return this.termStatistics;
    }

    public ObjectObjectOpenHashMap<String, CollectionStatistics> fieldStatistics() {
        return this.fieldStatistics;
    }

    public static DfsSearchResult readDfsSearchResult(StreamInput in) throws IOException, ClassNotFoundException {
        DfsSearchResult result2 = new DfsSearchResult();
        result2.readFrom(in);
        return result2;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.id = in.readLong();
        int termsSize = in.readVInt();
        if (termsSize == 0) {
            this.terms = EMPTY_TERMS;
        } else {
            this.terms = new Term[termsSize];
            for (int i = 0; i < this.terms.length; ++i) {
                this.terms[i] = new Term(in.readString(), in.readBytesRef());
            }
        }
        this.termStatistics = DfsSearchResult.readTermStats(in, this.terms);
        DfsSearchResult.readFieldStats(in, this.fieldStatistics);
        this.maxDoc = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.id);
        out.writeVInt(this.terms.length);
        for (Term term : this.terms) {
            out.writeString(term.field());
            out.writeBytesRef(term.bytes());
        }
        DfsSearchResult.writeTermStats(out, this.termStatistics);
        DfsSearchResult.writeFieldStats(out, this.fieldStatistics);
        out.writeVInt(this.maxDoc);
    }

    public static void writeFieldStats(StreamOutput out, ObjectObjectOpenHashMap<String, CollectionStatistics> fieldStatistics) throws IOException {
        out.writeVInt(fieldStatistics.size());
        boolean[] states = fieldStatistics.allocated;
        KType[] keys = fieldStatistics.keys;
        VType[] values2 = fieldStatistics.values;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            out.writeString((String)keys[i]);
            CollectionStatistics statistics = (CollectionStatistics)values2[i];
            assert (statistics.maxDoc() >= 0L);
            out.writeVLong(statistics.maxDoc());
            out.writeVLong(DfsSearchResult.addOne(statistics.docCount()));
            out.writeVLong(DfsSearchResult.addOne(statistics.sumTotalTermFreq()));
            out.writeVLong(DfsSearchResult.addOne(statistics.sumDocFreq()));
        }
    }

    public static void writeTermStats(StreamOutput out, TermStatistics[] termStatistics) throws IOException {
        out.writeVInt(termStatistics.length);
        for (TermStatistics termStatistic : termStatistics) {
            DfsSearchResult.writeSingleTermStats(out, termStatistic);
        }
    }

    public static void writeSingleTermStats(StreamOutput out, TermStatistics termStatistic) throws IOException {
        assert (termStatistic.docFreq() >= 0L);
        out.writeVLong(termStatistic.docFreq());
        out.writeVLong(DfsSearchResult.addOne(termStatistic.totalTermFreq()));
    }

    public static ObjectObjectOpenHashMap<String, CollectionStatistics> readFieldStats(StreamInput in) throws IOException {
        return DfsSearchResult.readFieldStats(in, null);
    }

    public static ObjectObjectOpenHashMap<String, CollectionStatistics> readFieldStats(StreamInput in, ObjectObjectOpenHashMap<String, CollectionStatistics> fieldStatistics) throws IOException {
        int numFieldStatistics = in.readVInt();
        if (fieldStatistics == null) {
            fieldStatistics = HppcMaps.newNoNullKeysMap(numFieldStatistics);
        }
        for (int i = 0; i < numFieldStatistics; ++i) {
            String field2 = in.readString();
            assert (field2 != null);
            long maxDoc = in.readVLong();
            long docCount = DfsSearchResult.subOne(in.readVLong());
            long sumTotalTermFreq = DfsSearchResult.subOne(in.readVLong());
            long sumDocFreq = DfsSearchResult.subOne(in.readVLong());
            CollectionStatistics stats = new CollectionStatistics(field2, maxDoc, docCount, sumTotalTermFreq, sumDocFreq);
            fieldStatistics.put(field2, stats);
        }
        return fieldStatistics;
    }

    public static TermStatistics[] readTermStats(StreamInput in, Term[] terms) throws IOException {
        TermStatistics[] termStatistics;
        int termsStatsSize = in.readVInt();
        if (termsStatsSize == 0) {
            termStatistics = EMPTY_TERM_STATS;
        } else {
            termStatistics = new TermStatistics[termsStatsSize];
            assert (terms.length == termsStatsSize);
            for (int i = 0; i < termStatistics.length; ++i) {
                BytesRef term = terms[i].bytes();
                long docFreq = in.readVLong();
                assert (docFreq >= 0L);
                long totalTermFreq = DfsSearchResult.subOne(in.readVLong());
                termStatistics[i] = new TermStatistics(term, docFreq, totalTermFreq);
            }
        }
        return termStatistics;
    }

    public static long addOne(long value2) {
        assert (value2 + 1L >= 0L);
        return value2 + 1L;
    }

    public static long subOne(long value2) {
        assert (value2 >= 0L);
        return value2 - 1L;
    }
}

