/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.search;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.support.IgnoreIndices;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestMultiSearchAction
extends BaseRestHandler {
    private final boolean allowExplicitIndex;

    @Inject
    public RestMultiSearchAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/_msearch", this);
        controller.registerHandler(RestRequest.Method.POST, "/_msearch", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_msearch", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_msearch", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_msearch", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_msearch", this);
        this.allowExplicitIndex = settings.getAsBoolean("rest.action.multi.allow_explicit_index", (Boolean)true);
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        MultiSearchRequest multiSearchRequest = new MultiSearchRequest();
        multiSearchRequest.listenerThreaded(false);
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        String[] types = Strings.splitStringByCommaToArray(request.param("type"));
        IgnoreIndices ignoreIndices = null;
        if (request.hasParam("ignore_indices")) {
            ignoreIndices = IgnoreIndices.fromString(request.param("ignore_indices"));
        }
        try {
            multiSearchRequest.add(request.content(), request.contentUnsafe(), indices, types, request.param("search_type"), request.param("routing"), ignoreIndices, this.allowExplicitIndex);
        }
        catch (Exception e) {
            try {
                XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                channel.sendResponse(new XContentRestResponse(request, RestStatus.BAD_REQUEST, builder.startObject().field("error", e.getMessage()).endObject()));
            }
            catch (IOException e1) {
                this.logger.error("Failed to send failure response", e1, new Object[0]);
            }
            return;
        }
        this.client.multiSearch(multiSearchRequest, new ActionListener<MultiSearchResponse>(){

            @Override
            public void onResponse(MultiSearchResponse response) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    builder.startObject();
                    response.toXContent(builder, request);
                    builder.endObject();
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                }
                catch (Throwable e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestMultiSearchAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }
}

