/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.deletebyquery;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.deletebyquery.DeleteByQueryRequest;
import org.elasticsearch.action.deletebyquery.DeleteByQueryResponse;
import org.elasticsearch.action.deletebyquery.IndexDeleteByQueryResponse;
import org.elasticsearch.action.deletebyquery.ShardDeleteByQueryRequest;
import org.elasticsearch.action.support.IgnoreIndices;
import org.elasticsearch.action.support.replication.ReplicationType;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestDeleteByQueryAction
extends BaseRestHandler {
    @Inject
    public RestDeleteByQueryAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.DELETE, "/{index}/_query", this);
        controller.registerHandler(RestRequest.Method.DELETE, "/{index}/{type}/_query", this);
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(Strings.splitStringByCommaToArray(request.param("index")));
        deleteByQueryRequest.listenerThreaded(false);
        try {
            String ignoreIndices;
            String consistencyLevel;
            if (request.hasContent()) {
                deleteByQueryRequest.query(request.content(), request.contentUnsafe());
            } else {
                String source = request.param("source");
                if (source != null) {
                    deleteByQueryRequest.query(source);
                } else {
                    BytesReference bytes = RestActions.parseQuerySource(request);
                    deleteByQueryRequest.query(bytes, false);
                }
            }
            deleteByQueryRequest.types(Strings.splitStringByCommaToArray(request.param("type")));
            deleteByQueryRequest.timeout(request.paramAsTime("timeout", ShardDeleteByQueryRequest.DEFAULT_TIMEOUT));
            deleteByQueryRequest.routing(request.param("routing"));
            String replicationType = request.param("replication");
            if (replicationType != null) {
                deleteByQueryRequest.replicationType(ReplicationType.fromString(replicationType));
            }
            if ((consistencyLevel = request.param("consistency")) != null) {
                deleteByQueryRequest.consistencyLevel(WriteConsistencyLevel.fromString(consistencyLevel));
            }
            if ((ignoreIndices = request.param("ignore_indices")) != null) {
                deleteByQueryRequest.ignoreIndices(IgnoreIndices.fromString(ignoreIndices));
            }
        }
        catch (Exception e) {
            try {
                XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                channel.sendResponse(new XContentRestResponse(request, RestStatus.PRECONDITION_FAILED, builder.startObject().field("error", e.getMessage()).endObject()));
            }
            catch (IOException e1) {
                this.logger.error("Failed to send failure response", e1, new Object[0]);
            }
            return;
        }
        this.client.deleteByQuery(deleteByQueryRequest, new ActionListener<DeleteByQueryResponse>(){

            @Override
            public void onResponse(DeleteByQueryResponse result2) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    builder.startObject().field("ok", true);
                    builder.startObject("_indices");
                    for (IndexDeleteByQueryResponse indexDeleteByQueryResponse : result2.getIndices().values()) {
                        builder.startObject(indexDeleteByQueryResponse.getIndex(), XContentBuilder.FieldCaseConversion.NONE);
                        builder.startObject("_shards");
                        builder.field("total", indexDeleteByQueryResponse.getTotalShards());
                        builder.field("successful", indexDeleteByQueryResponse.getSuccessfulShards());
                        builder.field("failed", indexDeleteByQueryResponse.getFailedShards());
                        builder.endObject();
                        builder.endObject();
                    }
                    builder.endObject();
                    builder.endObject();
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                }
                catch (Throwable e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestDeleteByQueryAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }
}

