/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.warmer.delete;

import org.elasticsearch.action.admin.indices.warmer.delete.DeleteWarmerRequest;
import org.elasticsearch.action.admin.indices.warmer.delete.DeleteWarmerResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.AcknowledgedRestResponseActionListener;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;

public class RestDeleteWarmerAction
extends BaseRestHandler {
    @Inject
    public RestDeleteWarmerAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.DELETE, "/{index}/_warmer", this);
        controller.registerHandler(RestRequest.Method.DELETE, "/{index}/_warmer/{name}", this);
        controller.registerHandler(RestRequest.Method.DELETE, "/{index}/{type}/_warmer/{name}", this);
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel) {
        DeleteWarmerRequest deleteWarmerRequest = new DeleteWarmerRequest(request.param("name")).indices(Strings.splitStringByCommaToArray(request.param("index")));
        deleteWarmerRequest.listenerThreaded(false);
        deleteWarmerRequest.timeout(request.paramAsTime("timeout", deleteWarmerRequest.timeout()));
        deleteWarmerRequest.masterNodeTimeout(request.paramAsTime("master_timeout", deleteWarmerRequest.masterNodeTimeout()));
        this.client.admin().indices().deleteWarmer(deleteWarmerRequest, new AcknowledgedRestResponseActionListener<DeleteWarmerResponse>(request, channel, this.logger));
    }
}

