/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.validate.query;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.validate.query.QueryExplanation;
import org.elasticsearch.action.admin.indices.validate.query.ValidateQueryRequest;
import org.elasticsearch.action.admin.indices.validate.query.ValidateQueryResponse;
import org.elasticsearch.action.support.IgnoreIndices;
import org.elasticsearch.action.support.broadcast.BroadcastOperationThreading;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestValidateQueryAction
extends BaseRestHandler {
    @Inject
    public RestValidateQueryAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/_validate/query", this);
        controller.registerHandler(RestRequest.Method.POST, "/_validate/query", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_validate/query", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_validate/query", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_validate/query", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_validate/query", this);
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        ValidateQueryRequest validateQueryRequest = new ValidateQueryRequest(Strings.splitStringByCommaToArray(request.param("index")));
        validateQueryRequest.listenerThreaded(false);
        if (request.hasParam("ignore_indices")) {
            validateQueryRequest.ignoreIndices(IgnoreIndices.fromString(request.param("ignore_indices")));
        }
        try {
            BroadcastOperationThreading operationThreading = BroadcastOperationThreading.fromString(request.param("operation_threading"), BroadcastOperationThreading.SINGLE_THREAD);
            if (operationThreading == BroadcastOperationThreading.NO_THREADS) {
                operationThreading = BroadcastOperationThreading.SINGLE_THREAD;
            }
            validateQueryRequest.operationThreading(operationThreading);
            if (request.hasContent()) {
                validateQueryRequest.query(request.content(), request.contentUnsafe());
            } else {
                String source = request.param("source");
                if (source != null) {
                    validateQueryRequest.query(source);
                } else {
                    BytesReference querySource = RestActions.parseQuerySource(request);
                    if (querySource != null) {
                        validateQueryRequest.query(querySource, false);
                    }
                }
            }
            validateQueryRequest.types(Strings.splitStringByCommaToArray(request.param("type")));
            if (request.paramAsBoolean("explain", false)) {
                validateQueryRequest.explain(true);
            } else {
                validateQueryRequest.explain(false);
            }
        }
        catch (Exception e) {
            try {
                XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                channel.sendResponse(new XContentRestResponse(request, RestStatus.BAD_REQUEST, builder.startObject().field("error", e.getMessage()).endObject()));
            }
            catch (IOException e1) {
                this.logger.error("Failed to send failure response", e1, new Object[0]);
            }
            return;
        }
        this.client.admin().indices().validateQuery(validateQueryRequest, new ActionListener<ValidateQueryResponse>(){

            @Override
            public void onResponse(ValidateQueryResponse response) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    builder.startObject();
                    builder.field("valid", response.isValid());
                    RestActions.buildBroadcastShardsHeader(builder, response);
                    if (response.getQueryExplanation() != null && !response.getQueryExplanation().isEmpty()) {
                        builder.startArray("explanations");
                        for (QueryExplanation queryExplanation : response.getQueryExplanation()) {
                            builder.startObject();
                            if (queryExplanation.getIndex() != null) {
                                builder.field("index", queryExplanation.getIndex(), XContentBuilder.FieldCaseConversion.NONE);
                            }
                            builder.field("valid", queryExplanation.isValid());
                            if (queryExplanation.getError() != null) {
                                builder.field("error", queryExplanation.getError());
                            }
                            if (queryExplanation.getExplanation() != null) {
                                builder.field("explanation", queryExplanation.getExplanation());
                            }
                            builder.endObject();
                        }
                        builder.endArray();
                    }
                    builder.endObject();
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                }
                catch (Throwable e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestValidateQueryAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }
}

