/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.template.head;

import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesRequest;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.StringRestResponse;

public class RestHeadIndexTemplateAction
extends BaseRestHandler {
    @Inject
    public RestHeadIndexTemplateAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.HEAD, "/_template/{name}", this);
    }

    @Override
    public void handleRequest(RestRequest request, final RestChannel channel) {
        GetIndexTemplatesRequest getIndexTemplatesRequest = new GetIndexTemplatesRequest(request.param("name"));
        this.client.admin().indices().getTemplates(getIndexTemplatesRequest, new ActionListener<GetIndexTemplatesResponse>(){

            @Override
            public void onResponse(GetIndexTemplatesResponse getIndexTemplatesResponse) {
                try {
                    boolean templateExists;
                    boolean bl = templateExists = getIndexTemplatesResponse.getIndexTemplates().size() > 0;
                    if (templateExists) {
                        channel.sendResponse(new StringRestResponse(RestStatus.OK));
                    } else {
                        channel.sendResponse(new StringRestResponse(RestStatus.NOT_FOUND));
                    }
                }
                catch (Throwable e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new StringRestResponse(ExceptionsHelper.status(e)));
                }
                catch (Exception e1) {
                    RestHeadIndexTemplateAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }
}

