/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.stats;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.support.IgnoreIndices;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestIndicesStatsAction
extends BaseRestHandler {
    @Inject
    public RestIndicesStatsAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/_stats", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_stats", this);
        controller.registerHandler(RestRequest.Method.GET, "_stats/docs", new RestDocsStatsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_stats/docs", new RestDocsStatsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/_stats/store", new RestStoreStatsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_stats/store", new RestStoreStatsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/_stats/indexing", new RestIndexingStatsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_stats/indexing", new RestIndexingStatsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/_stats/indexing/{indexingTypes1}", new RestIndexingStatsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_stats/indexing/{indexingTypes2}", new RestIndexingStatsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/_stats/search", new RestSearchStatsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_stats/search", new RestSearchStatsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/_stats/search/{searchGroupsStats1}", new RestSearchStatsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_stats/search/{searchGroupsStats2}", new RestSearchStatsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/_stats/get", new RestGetStatsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_stats/get", new RestGetStatsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/_stats/refresh", new RestRefreshStatsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_stats/refresh", new RestRefreshStatsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/_stats/merge", new RestMergeStatsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_stats/merge", new RestMergeStatsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/_stats/flush", new RestFlushStatsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_stats/flush", new RestFlushStatsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/_stats/warmer", new RestWarmerStatsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_stats/warmer", new RestWarmerStatsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/_stats/filter_cache", new RestFilterCacheStatsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_stats/filter_cache", new RestFilterCacheStatsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/_stats/id_cache", new RestIdCacheStatsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_stats/id_cache", new RestIdCacheStatsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/_stats/fielddata", new RestFieldDataStatsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_stats/fielddata", new RestFieldDataStatsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/_stats/fielddata/{fields}", new RestFieldDataStatsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_stats/fielddata/{fields}", new RestFieldDataStatsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/_stats/completion", new RestCompletionStatsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_stats/completion", new RestCompletionStatsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/_stats/completion/{fields}", new RestCompletionStatsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_stats/completion/{fields}", new RestCompletionStatsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/_stats/segments", new RestSegmentsStatsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_stats/segments", new RestSegmentsStatsHandler());
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        boolean all;
        boolean clear2;
        IndicesStatsRequest indicesStatsRequest = new IndicesStatsRequest();
        indicesStatsRequest.listenerThreaded(false);
        if (request.hasParam("ignore_indices")) {
            indicesStatsRequest.ignoreIndices(IgnoreIndices.fromString(request.param("ignore_indices")));
        }
        if (clear2 = request.paramAsBoolean("clear", false)) {
            indicesStatsRequest.clear();
        }
        if (all = request.paramAsBoolean("all", false)) {
            indicesStatsRequest.all();
        }
        indicesStatsRequest.indices(Strings.splitStringByCommaToArray(request.param("index")));
        indicesStatsRequest.types(Strings.splitStringByCommaToArray(request.param("types")));
        if (request.hasParam("groups")) {
            indicesStatsRequest.groups(Strings.splitStringByCommaToArray(request.param("groups")));
        }
        String[] defaultIncludedFields = request.paramAsStringArray("fields", null);
        indicesStatsRequest.docs(request.paramAsBoolean("docs", indicesStatsRequest.docs()));
        indicesStatsRequest.store(request.paramAsBoolean("store", indicesStatsRequest.store()));
        indicesStatsRequest.indexing(request.paramAsBoolean("indexing", indicesStatsRequest.indexing()));
        indicesStatsRequest.search(request.paramAsBoolean("search", indicesStatsRequest.search()));
        indicesStatsRequest.get(request.paramAsBoolean("get", indicesStatsRequest.get()));
        indicesStatsRequest.merge(request.paramAsBoolean("merge", indicesStatsRequest.merge()));
        indicesStatsRequest.refresh(request.paramAsBoolean("refresh", indicesStatsRequest.refresh()));
        indicesStatsRequest.flush(request.paramAsBoolean("flush", indicesStatsRequest.flush()));
        indicesStatsRequest.warmer(request.paramAsBoolean("warmer", indicesStatsRequest.warmer()));
        indicesStatsRequest.filterCache(request.paramAsBoolean("filter_cache", indicesStatsRequest.filterCache()));
        indicesStatsRequest.idCache(request.paramAsBoolean("id_cache", indicesStatsRequest.idCache()));
        indicesStatsRequest.fieldData(request.paramAsBoolean("fielddata", indicesStatsRequest.fieldData()));
        indicesStatsRequest.fieldDataFields(request.paramAsStringArray("fielddata_fields", defaultIncludedFields));
        indicesStatsRequest.segments(request.paramAsBoolean("segments", indicesStatsRequest.segments()));
        indicesStatsRequest.completion(request.paramAsBoolean("completion", indicesStatsRequest.completion()));
        indicesStatsRequest.completionFields(request.paramAsStringArray("completion_fields", defaultIncludedFields));
        this.client.admin().indices().stats(indicesStatsRequest, new ActionListener<IndicesStatsResponse>(){

            @Override
            public void onResponse(IndicesStatsResponse response) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    builder.startObject();
                    builder.field("ok", true);
                    RestActions.buildBroadcastShardsHeader(builder, response);
                    response.toXContent(builder, request);
                    builder.endObject();
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                }
                catch (Throwable e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestIndicesStatsAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }

    class RestSegmentsStatsHandler
    implements RestHandler {
        RestSegmentsStatsHandler() {
        }

        @Override
        public void handleRequest(final RestRequest request, final RestChannel channel) {
            IndicesStatsRequest indicesStatsRequest = new IndicesStatsRequest();
            indicesStatsRequest.listenerThreaded(false);
            indicesStatsRequest.clear().segments(true);
            indicesStatsRequest.indices(Strings.splitStringByCommaToArray(request.param("index")));
            RestIndicesStatsAction.this.client.admin().indices().stats(indicesStatsRequest, new ActionListener<IndicesStatsResponse>(){

                @Override
                public void onResponse(IndicesStatsResponse response) {
                    try {
                        XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                        builder.startObject();
                        builder.field("ok", true);
                        RestActions.buildBroadcastShardsHeader(builder, response);
                        response.toXContent(builder, request);
                        builder.endObject();
                        channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(new XContentThrowableRestResponse(request, e));
                    }
                    catch (IOException e1) {
                        RestIndicesStatsAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                    }
                }
            });
        }
    }

    class RestRefreshStatsHandler
    implements RestHandler {
        RestRefreshStatsHandler() {
        }

        @Override
        public void handleRequest(final RestRequest request, final RestChannel channel) {
            IndicesStatsRequest indicesStatsRequest = new IndicesStatsRequest();
            indicesStatsRequest.listenerThreaded(false);
            indicesStatsRequest.clear().refresh(true);
            indicesStatsRequest.indices(Strings.splitStringByCommaToArray(request.param("index")));
            indicesStatsRequest.types(Strings.splitStringByCommaToArray(request.param("types")));
            RestIndicesStatsAction.this.client.admin().indices().stats(indicesStatsRequest, new ActionListener<IndicesStatsResponse>(){

                @Override
                public void onResponse(IndicesStatsResponse response) {
                    try {
                        XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                        builder.startObject();
                        builder.field("ok", true);
                        RestActions.buildBroadcastShardsHeader(builder, response);
                        response.toXContent(builder, request);
                        builder.endObject();
                        channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(new XContentThrowableRestResponse(request, e));
                    }
                    catch (IOException e1) {
                        RestIndicesStatsAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                    }
                }
            });
        }
    }

    class RestCompletionStatsHandler
    implements RestHandler {
        RestCompletionStatsHandler() {
        }

        @Override
        public void handleRequest(final RestRequest request, final RestChannel channel) {
            IndicesStatsRequest indicesStatsRequest = new IndicesStatsRequest();
            indicesStatsRequest.listenerThreaded(false);
            indicesStatsRequest.clear().completion(true);
            indicesStatsRequest.indices(Strings.splitStringByCommaToArray(request.param("index")));
            indicesStatsRequest.types(Strings.splitStringByCommaToArray(request.param("types")));
            indicesStatsRequest.completionFields(request.paramAsStringArray("fields", null));
            RestIndicesStatsAction.this.client.admin().indices().stats(indicesStatsRequest, new ActionListener<IndicesStatsResponse>(){

                @Override
                public void onResponse(IndicesStatsResponse response) {
                    try {
                        XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                        builder.startObject();
                        builder.field("ok", true);
                        RestActions.buildBroadcastShardsHeader(builder, response);
                        response.toXContent(builder, request);
                        builder.endObject();
                        channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(new XContentThrowableRestResponse(request, e));
                    }
                    catch (IOException e1) {
                        RestIndicesStatsAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                    }
                }
            });
        }
    }

    class RestFieldDataStatsHandler
    implements RestHandler {
        RestFieldDataStatsHandler() {
        }

        @Override
        public void handleRequest(final RestRequest request, final RestChannel channel) {
            IndicesStatsRequest indicesStatsRequest = new IndicesStatsRequest();
            indicesStatsRequest.listenerThreaded(false);
            indicesStatsRequest.clear().fieldData(true);
            indicesStatsRequest.indices(Strings.splitStringByCommaToArray(request.param("index")));
            indicesStatsRequest.types(Strings.splitStringByCommaToArray(request.param("types")));
            indicesStatsRequest.fieldDataFields(request.paramAsStringArray("fields", null));
            RestIndicesStatsAction.this.client.admin().indices().stats(indicesStatsRequest, new ActionListener<IndicesStatsResponse>(){

                @Override
                public void onResponse(IndicesStatsResponse response) {
                    try {
                        XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                        builder.startObject();
                        builder.field("ok", true);
                        RestActions.buildBroadcastShardsHeader(builder, response);
                        response.toXContent(builder, request);
                        builder.endObject();
                        channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(new XContentThrowableRestResponse(request, e));
                    }
                    catch (IOException e1) {
                        RestIndicesStatsAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                    }
                }
            });
        }
    }

    class RestIdCacheStatsHandler
    implements RestHandler {
        RestIdCacheStatsHandler() {
        }

        @Override
        public void handleRequest(final RestRequest request, final RestChannel channel) {
            IndicesStatsRequest indicesStatsRequest = new IndicesStatsRequest();
            indicesStatsRequest.listenerThreaded(false);
            indicesStatsRequest.clear().idCache(true);
            indicesStatsRequest.indices(Strings.splitStringByCommaToArray(request.param("index")));
            indicesStatsRequest.types(Strings.splitStringByCommaToArray(request.param("types")));
            RestIndicesStatsAction.this.client.admin().indices().stats(indicesStatsRequest, new ActionListener<IndicesStatsResponse>(){

                @Override
                public void onResponse(IndicesStatsResponse response) {
                    try {
                        XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                        builder.startObject();
                        builder.field("ok", true);
                        RestActions.buildBroadcastShardsHeader(builder, response);
                        response.toXContent(builder, request);
                        builder.endObject();
                        channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(new XContentThrowableRestResponse(request, e));
                    }
                    catch (IOException e1) {
                        RestIndicesStatsAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                    }
                }
            });
        }
    }

    class RestFilterCacheStatsHandler
    implements RestHandler {
        RestFilterCacheStatsHandler() {
        }

        @Override
        public void handleRequest(final RestRequest request, final RestChannel channel) {
            IndicesStatsRequest indicesStatsRequest = new IndicesStatsRequest();
            indicesStatsRequest.listenerThreaded(false);
            indicesStatsRequest.clear().filterCache(true);
            indicesStatsRequest.indices(Strings.splitStringByCommaToArray(request.param("index")));
            indicesStatsRequest.types(Strings.splitStringByCommaToArray(request.param("types")));
            RestIndicesStatsAction.this.client.admin().indices().stats(indicesStatsRequest, new ActionListener<IndicesStatsResponse>(){

                @Override
                public void onResponse(IndicesStatsResponse response) {
                    try {
                        XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                        builder.startObject();
                        builder.field("ok", true);
                        RestActions.buildBroadcastShardsHeader(builder, response);
                        response.toXContent(builder, request);
                        builder.endObject();
                        channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(new XContentThrowableRestResponse(request, e));
                    }
                    catch (IOException e1) {
                        RestIndicesStatsAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                    }
                }
            });
        }
    }

    class RestWarmerStatsHandler
    implements RestHandler {
        RestWarmerStatsHandler() {
        }

        @Override
        public void handleRequest(final RestRequest request, final RestChannel channel) {
            IndicesStatsRequest indicesStatsRequest = new IndicesStatsRequest();
            indicesStatsRequest.listenerThreaded(false);
            indicesStatsRequest.clear().warmer(true);
            indicesStatsRequest.indices(Strings.splitStringByCommaToArray(request.param("index")));
            indicesStatsRequest.types(Strings.splitStringByCommaToArray(request.param("types")));
            RestIndicesStatsAction.this.client.admin().indices().stats(indicesStatsRequest, new ActionListener<IndicesStatsResponse>(){

                @Override
                public void onResponse(IndicesStatsResponse response) {
                    try {
                        XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                        builder.startObject();
                        builder.field("ok", true);
                        RestActions.buildBroadcastShardsHeader(builder, response);
                        response.toXContent(builder, request);
                        builder.endObject();
                        channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(new XContentThrowableRestResponse(request, e));
                    }
                    catch (IOException e1) {
                        RestIndicesStatsAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                    }
                }
            });
        }
    }

    class RestFlushStatsHandler
    implements RestHandler {
        RestFlushStatsHandler() {
        }

        @Override
        public void handleRequest(final RestRequest request, final RestChannel channel) {
            IndicesStatsRequest indicesStatsRequest = new IndicesStatsRequest();
            indicesStatsRequest.listenerThreaded(false);
            indicesStatsRequest.clear().flush(true);
            indicesStatsRequest.indices(Strings.splitStringByCommaToArray(request.param("index")));
            indicesStatsRequest.types(Strings.splitStringByCommaToArray(request.param("types")));
            RestIndicesStatsAction.this.client.admin().indices().stats(indicesStatsRequest, new ActionListener<IndicesStatsResponse>(){

                @Override
                public void onResponse(IndicesStatsResponse response) {
                    try {
                        XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                        builder.startObject();
                        builder.field("ok", true);
                        RestActions.buildBroadcastShardsHeader(builder, response);
                        response.toXContent(builder, request);
                        builder.endObject();
                        channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(new XContentThrowableRestResponse(request, e));
                    }
                    catch (IOException e1) {
                        RestIndicesStatsAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                    }
                }
            });
        }
    }

    class RestMergeStatsHandler
    implements RestHandler {
        RestMergeStatsHandler() {
        }

        @Override
        public void handleRequest(final RestRequest request, final RestChannel channel) {
            IndicesStatsRequest indicesStatsRequest = new IndicesStatsRequest();
            indicesStatsRequest.listenerThreaded(false);
            indicesStatsRequest.clear().merge(true);
            indicesStatsRequest.indices(Strings.splitStringByCommaToArray(request.param("index")));
            indicesStatsRequest.types(Strings.splitStringByCommaToArray(request.param("types")));
            RestIndicesStatsAction.this.client.admin().indices().stats(indicesStatsRequest, new ActionListener<IndicesStatsResponse>(){

                @Override
                public void onResponse(IndicesStatsResponse response) {
                    try {
                        XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                        builder.startObject();
                        builder.field("ok", true);
                        RestActions.buildBroadcastShardsHeader(builder, response);
                        response.toXContent(builder, request);
                        builder.endObject();
                        channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(new XContentThrowableRestResponse(request, e));
                    }
                    catch (IOException e1) {
                        RestIndicesStatsAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                    }
                }
            });
        }
    }

    class RestGetStatsHandler
    implements RestHandler {
        RestGetStatsHandler() {
        }

        @Override
        public void handleRequest(final RestRequest request, final RestChannel channel) {
            IndicesStatsRequest indicesStatsRequest = new IndicesStatsRequest();
            indicesStatsRequest.listenerThreaded(false);
            indicesStatsRequest.clear().get(true);
            indicesStatsRequest.indices(Strings.splitStringByCommaToArray(request.param("index")));
            RestIndicesStatsAction.this.client.admin().indices().stats(indicesStatsRequest, new ActionListener<IndicesStatsResponse>(){

                @Override
                public void onResponse(IndicesStatsResponse response) {
                    try {
                        XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                        builder.startObject();
                        builder.field("ok", true);
                        RestActions.buildBroadcastShardsHeader(builder, response);
                        response.toXContent(builder, request);
                        builder.endObject();
                        channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(new XContentThrowableRestResponse(request, e));
                    }
                    catch (IOException e1) {
                        RestIndicesStatsAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                    }
                }
            });
        }
    }

    class RestSearchStatsHandler
    implements RestHandler {
        RestSearchStatsHandler() {
        }

        @Override
        public void handleRequest(final RestRequest request, final RestChannel channel) {
            IndicesStatsRequest indicesStatsRequest = new IndicesStatsRequest();
            indicesStatsRequest.listenerThreaded(false);
            indicesStatsRequest.clear().search(true);
            indicesStatsRequest.indices(Strings.splitStringByCommaToArray(request.param("index")));
            if (request.hasParam("groups")) {
                indicesStatsRequest.groups(Strings.splitStringByCommaToArray(request.param("groups")));
            } else if (request.hasParam("searchGroupsStats1")) {
                indicesStatsRequest.groups(Strings.splitStringByCommaToArray(request.param("searchGroupsStats1")));
            } else if (request.hasParam("searchGroupsStats2")) {
                indicesStatsRequest.groups(Strings.splitStringByCommaToArray(request.param("searchGroupsStats2")));
            }
            RestIndicesStatsAction.this.client.admin().indices().stats(indicesStatsRequest, new ActionListener<IndicesStatsResponse>(){

                @Override
                public void onResponse(IndicesStatsResponse response) {
                    try {
                        XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                        builder.startObject();
                        builder.field("ok", true);
                        RestActions.buildBroadcastShardsHeader(builder, response);
                        response.toXContent(builder, request);
                        builder.endObject();
                        channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(new XContentThrowableRestResponse(request, e));
                    }
                    catch (IOException e1) {
                        RestIndicesStatsAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                    }
                }
            });
        }
    }

    class RestIndexingStatsHandler
    implements RestHandler {
        RestIndexingStatsHandler() {
        }

        @Override
        public void handleRequest(final RestRequest request, final RestChannel channel) {
            IndicesStatsRequest indicesStatsRequest = new IndicesStatsRequest();
            indicesStatsRequest.listenerThreaded(false);
            indicesStatsRequest.clear().indexing(true);
            indicesStatsRequest.indices(Strings.splitStringByCommaToArray(request.param("index")));
            if (request.hasParam("types")) {
                indicesStatsRequest.types(Strings.splitStringByCommaToArray(request.param("types")));
            } else if (request.hasParam("indexingTypes1")) {
                indicesStatsRequest.types(Strings.splitStringByCommaToArray(request.param("indexingTypes1")));
            } else if (request.hasParam("indexingTypes2")) {
                indicesStatsRequest.types(Strings.splitStringByCommaToArray(request.param("indexingTypes2")));
            }
            RestIndicesStatsAction.this.client.admin().indices().stats(indicesStatsRequest, new ActionListener<IndicesStatsResponse>(){

                @Override
                public void onResponse(IndicesStatsResponse response) {
                    try {
                        XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                        builder.startObject();
                        builder.field("ok", true);
                        RestActions.buildBroadcastShardsHeader(builder, response);
                        response.toXContent(builder, request);
                        builder.endObject();
                        channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(new XContentThrowableRestResponse(request, e));
                    }
                    catch (IOException e1) {
                        RestIndicesStatsAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                    }
                }
            });
        }
    }

    class RestStoreStatsHandler
    implements RestHandler {
        RestStoreStatsHandler() {
        }

        @Override
        public void handleRequest(final RestRequest request, final RestChannel channel) {
            IndicesStatsRequest indicesStatsRequest = new IndicesStatsRequest();
            indicesStatsRequest.listenerThreaded(false);
            indicesStatsRequest.clear().store(true);
            indicesStatsRequest.indices(Strings.splitStringByCommaToArray(request.param("index")));
            indicesStatsRequest.types(Strings.splitStringByCommaToArray(request.param("types")));
            RestIndicesStatsAction.this.client.admin().indices().stats(indicesStatsRequest, new ActionListener<IndicesStatsResponse>(){

                @Override
                public void onResponse(IndicesStatsResponse response) {
                    try {
                        XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                        builder.startObject();
                        builder.field("ok", true);
                        RestActions.buildBroadcastShardsHeader(builder, response);
                        response.toXContent(builder, request);
                        builder.endObject();
                        channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(new XContentThrowableRestResponse(request, e));
                    }
                    catch (IOException e1) {
                        RestIndicesStatsAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                    }
                }
            });
        }
    }

    class RestDocsStatsHandler
    implements RestHandler {
        RestDocsStatsHandler() {
        }

        @Override
        public void handleRequest(final RestRequest request, final RestChannel channel) {
            IndicesStatsRequest indicesStatsRequest = new IndicesStatsRequest();
            indicesStatsRequest.listenerThreaded(false);
            indicesStatsRequest.clear().docs(true);
            indicesStatsRequest.indices(Strings.splitStringByCommaToArray(request.param("index")));
            indicesStatsRequest.types(Strings.splitStringByCommaToArray(request.param("types")));
            RestIndicesStatsAction.this.client.admin().indices().stats(indicesStatsRequest, new ActionListener<IndicesStatsResponse>(){

                @Override
                public void onResponse(IndicesStatsResponse response) {
                    try {
                        XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                        builder.startObject();
                        builder.field("ok", true);
                        RestActions.buildBroadcastShardsHeader(builder, response);
                        response.toXContent(builder, request);
                        builder.endObject();
                        channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(new XContentThrowableRestResponse(request, e));
                    }
                    catch (IOException e1) {
                        RestIndicesStatsAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                    }
                }
            });
        }
    }
}

