/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.settings;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.admin.indices.settings.UpdateSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.UpdateSettingsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.rest.AcknowledgedRestResponseActionListener;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentThrowableRestResponse;

public class RestUpdateSettingsAction
extends BaseRestHandler {
    @Inject
    public RestUpdateSettingsAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_settings", this);
        controller.registerHandler(RestRequest.Method.PUT, "/_settings", this);
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel) {
        UpdateSettingsRequest updateSettingsRequest = Requests.updateSettingsRequest(Strings.splitStringByCommaToArray(request.param("index")));
        updateSettingsRequest.listenerThreaded(false);
        updateSettingsRequest.timeout(request.paramAsTime("timeout", updateSettingsRequest.timeout()));
        updateSettingsRequest.masterNodeTimeout(request.paramAsTime("master_timeout", updateSettingsRequest.masterNodeTimeout()));
        ImmutableSettings.Builder updateSettings = ImmutableSettings.settingsBuilder();
        String bodySettingsStr = request.content().toUtf8();
        if (Strings.hasText(bodySettingsStr)) {
            try {
                Settings buildSettings = ImmutableSettings.settingsBuilder().loadFromSource(bodySettingsStr).build();
                for (Map.Entry entry2 : buildSettings.getAsMap().entrySet()) {
                    String key = (String)entry2.getKey();
                    String value2 = (String)entry2.getValue();
                    if (key.startsWith("settings.")) {
                        key = key.substring("settings.".length());
                    }
                    updateSettings.put(key, value2);
                }
            }
            catch (Exception e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, RestStatus.BAD_REQUEST, new SettingsException("Failed to parse index settings", e)));
                }
                catch (IOException e1) {
                    this.logger.warn("Failed to send response", e1, new Object[0]);
                }
                return;
            }
        }
        for (Map.Entry<String, String> entry3 : request.params().entrySet()) {
            if (entry3.getKey().equals("pretty")) continue;
            updateSettings.put(entry3.getKey(), entry3.getValue());
        }
        updateSettingsRequest.settings(updateSettings);
        this.client.admin().indices().updateSettings(updateSettingsRequest, new AcknowledgedRestResponseActionListener<UpdateSettingsResponse>(request, channel, this.logger));
    }
}

