/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.mapping.get;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestGetFieldMappingAction
extends BaseRestHandler {
    @Inject
    public RestGetFieldMappingAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/_mapping/field/{fields}", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_mapping/field/{fields}", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_mapping/field/{fields}", this);
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        String[] types = Strings.splitStringByCommaToArray(request.param("type"));
        boolean local = request.paramAsBooleanOptional("local", false);
        final String[] fields = Strings.splitStringByCommaToArray(request.param("fields"));
        GetFieldMappingsRequest getMappingsRequest = new GetFieldMappingsRequest();
        ((GetFieldMappingsRequest)((GetFieldMappingsRequest)((GetFieldMappingsRequest)getMappingsRequest.indices(indices)).types(types)).local(local)).fields(fields).includeDefaults(request.paramAsBoolean("include_defaults", false));
        this.client.admin().indices().getFieldMappings(getMappingsRequest, new ActionListener<GetFieldMappingsResponse>(){

            @Override
            public void onResponse(GetFieldMappingsResponse response) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    builder.startObject();
                    ImmutableMap<String, ImmutableMap<String, ImmutableMap<String, GetFieldMappingsResponse.FieldMappingMetaData>>> mappingsByIndex = response.mappings();
                    RestStatus status = RestStatus.OK;
                    if (mappingsByIndex.isEmpty() && fields.length > 0) {
                        status = RestStatus.NOT_FOUND;
                    }
                    response.toXContent(builder, ToXContent.EMPTY_PARAMS);
                    builder.endObject();
                    channel.sendResponse(new XContentRestResponse(request, status, builder));
                }
                catch (Throwable e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestGetFieldMappingAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }
}

