/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.mapping.delete;

import org.elasticsearch.action.admin.indices.mapping.delete.DeleteMappingRequest;
import org.elasticsearch.action.admin.indices.mapping.delete.DeleteMappingResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.AcknowledgedRestResponseActionListener;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;

public class RestDeleteMappingAction
extends BaseRestHandler {
    @Inject
    public RestDeleteMappingAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.DELETE, "/{index}/{type}/_mapping", this);
        controller.registerHandler(RestRequest.Method.DELETE, "/{index}/{type}", this);
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel) {
        DeleteMappingRequest deleteMappingRequest = Requests.deleteMappingRequest(Strings.splitStringByCommaToArray(request.param("index")));
        deleteMappingRequest.listenerThreaded(false);
        deleteMappingRequest.type(request.param("type"));
        deleteMappingRequest.timeout(request.paramAsTime("timeout", deleteMappingRequest.timeout()));
        deleteMappingRequest.masterNodeTimeout(request.paramAsTime("master_timeout", deleteMappingRequest.masterNodeTimeout()));
        this.client.admin().indices().deleteMapping(deleteMappingRequest, new AcknowledgedRestResponseActionListener<DeleteMappingResponse>(request, channel, this.logger));
    }
}

